<?php

namespace App\Http\Requests;

use App\Models\Circle;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateCircleRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('circle_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'is_active' => [
                'boolean',
            ],
            'state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],
        ];
    }
}
