<?php

namespace App\Http\Requests;

use App\Models\Ledger;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreLedgerRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('ledger_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'description' => [
                'string',
                'nullable',
            ],
            'ledger_group_id' => [
                'integer',
                'exists:ledger_groups,id',
                'required',
            ],
        ];
    }
}
