<?php

namespace App\Http\Requests;

use App\Models\EmployeeFamilyDetail;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreEmployeeFamilyDetailRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('employee_family_detail_create'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'employee_info_id' => [
                'integer',
                'exists:employee_infos,id',
                'nullable',
            ],
            'relation' => [
                'nullable',
                'in:' . implode(',', array_keys(EmployeeFamilyDetail::RELATION_RADIO)),
            ],
            'name' => [
                'string',
                'nullable',
            ],
            'is_dependent' => [
                'boolean',
            ],
            'profession' => [
                'string',
                'nullable',
            ],
            'office_name_address' => [
                'string',
                'nullable',
            ],
            'office_contact' => [
                'string',
                'nullable',
            ],
        ];
    }
}
