<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;

class ForceHttpsProtocol
{
    public $except = [];
    public $exceptHosts = [
        ''

    ];
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // dd($request, $_SERVER);
        if ($this->isSecureNeeded($request)) {
            // // if (!$request->secure() && App::environment() === 'production') {
            if (!$request->secure()) {
                return redirect()->secure($request->getRequestUri());
            }
        }

        // dd($request->path());
        // $urlData = parse_url($request->url());

        // dd($urlData);

        return $next($request);
    }

    public function isSecureNeeded($request)
    {
        $sec = true;
        $isLocal = $this->isLocalOrTestViaTLD($request);

        if ($isLocal) return false;
        $sec  = !collect($this->except)->contains($request->path());

        return $sec;
    }
    
    public function isLocalOrTestViaTLD($request, $tldsXtra = [])
    {
        $defaultLocalhostTlds = [
            "test",
            "localhost",
            "local",
            "dev",
            "127.0.0.1",
        ];
        // $host = request()->root();
        $host = $_SERVER["SERVER_NAME"];

        $localhostTlds = collect($defaultLocalhostTlds)->merge($tldsXtra)->toArray();
        $patt = "/(" . join("|", $localhostTlds) . ")\$/";
        // $match =   request()->is($patt);
        $match = preg_match($patt, $host, $matches);
        return (bool)$match;
    }
}
