<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CorsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // // return $next($request);
        // if ($request->getMethod() == "OPTIONS") {
        //     $headers = [
        //         'Access-Control-Allow-Methods' => 'POST, GET, OPTIONS, PUT, DELETE',
        //         'Access-Control-Allow-Headers' => 'Content-Type, Origin, Authorization'
        //     ];
        //     return response()->make('OK', 200, $headers);
        // }
        // return $next($request);

        return $next($request)
            ->header('Access-Control-Allow-Origin', '*')
            ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
            ->header('Access-Control-Allow-Headers', 'Content-Type, Origin, Authorization, X-FCM-Token, Accept');
    }
}
