<?php

namespace App\Http\Livewire\Zone;

use App\Models\State;
use App\Models\User;
use App\Models\Zone;
use Livewire\Component;

class Edit extends Component
{
    public Zone $zone;
    public array $listsForFields = [];
    public function mount(Zone $zone)
    {
        $this->zone = $zone;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.zone.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->zone->save();

        return redirect()->route('admin.zones.index');
    }

    protected function rules(): array
    {
        return [
            'zone.name' => [
                'string',
                'required',
            ],
            'zone.is_active' => [
                'boolean',
            ],
            'zone.state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],
            'zone.zonal_officer_id' => [
                'integer',
                // 'exists:states,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['states']   = State::pluck('name', 'id')->toArray();

        $this->listsForFields['zonal_officers'] = User::whereHas('roles', function ($query) {
            $query->where('role_id', 7);
        })->get()->pluck('name_role', 'id')->toArray();
    }
}
