<?php

namespace App\Http\Livewire\ZonalOfficer\Zone\Product;

use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductZoneHistory;
use App\Models\ProductZonePivot;
use App\Models\User;
use App\Models\Zone;
use Livewire\Component;

class ZoneWiseProductListComponent extends Component
{
    public array $listsForFields = [];

    // public Zone|null $selectedZone;
    // public  $zone_id;
    public Zone $zone;
    public $filters = [
        'categories' => [],
    ];
    public $state = [
        'stock' => [],
    ];
    protected $queryString = [
        // 'zone_id' => [
        //     'except' => null,
        //     'as' => 'zone',
        // ]
    ];



    public function mount(Zone $zone)
    {

        // $this->productZonePivot->quantity = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        $data = [];
        // $zone = Zone::find($this->zone->id);
        $zone = $this->zone;

        if ($zone) {
            // $this->state['productZonePivots'] = ProductZonePivot::where('zone_id', $this->zone->id)->get();
            $prodQuery = Product::query();
            // select  products that matches filters->categories
            if (!empty($this->filters['categories'])) {
                $prodQuery->whereHas('category', function ($query) {
                    $query->whereIn('id', $this->filters['categories']);
                });
            }


            //
            $data['products'] = $prodQuery->with([
                'zones' => function ($query) {
                    $query->where('zone_id', $this->zone->id)
                        // ->select('id', 'name', 'stock')
                    ;
                },
                // 'productZonePivots' => function ($query) {
                //     $query->where('zone_id', $this->zone->id);
                // }
            ])->get()
                ->map(function ($product) {
                    $zone = ($product->zones->first());
                    $product->stock = $zone ? $zone->pivot->quantity : 0;
                    return $product;
                });
        } else {

            $data['products'] = Product::where('id', '-9')->get();
            // reset zone_id
            $this->reset('zone_id');
        }
        $data['zone'] = $zone;

        return view('livewire.zonal-officer.zone.product.zone-wise-product-list-component', $data);
    }

    public function submit()
    {
        // $this->validate();
        // $this->productZonePivot->save();

        // return redirect()->route('admin.product-zone-pivots.index');
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['zone']            = Zone::pluck('name', 'id')->toArray();
        $this->listsForFields['categories']      = ProductCategory::pluck('name', 'id')->toArray();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
    }

    public function updatedZoneId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        $this->resetErrorBag();
    }

    public function loadProducts()
    {
    }

    public function addStocks()
    {
        $user = auth()->user();
        $this->validate([
            'state.stock.*.add' => 'required|integer|min:1',
        ], [
            'state.stock.*.add.required' => 'Please enter stock',
            'state.stock.*.add.integer' => 'Please enter valid stock',
            'state.stock.*.add.min' => 'Please enter valid stock',
        ]);
        $productIds = array_keys($this->state['stock']);
        $productZonePivots = ProductZonePivot::whereIn('product_id', $productIds)
            ->where('zone_id', $this->zone->id)->get();

        foreach ($this->state['stock'] as $key => $stock) {
            $productZonePivot = $productZonePivots->where('product_id', $key)
                ->where('zone_id', $this->zone->id)
                ->first();
            $quantity_before = 0;
            $stockToAdd = $stock['add'];
            if ($productZonePivot) {
                $quantity_before = $productZonePivot->quantity;
                $productZonePivot->quantity += $stock['add'];
                $productZonePivot->save();
            } else {
                ProductZonePivot::create([
                    'product_id' => $key,
                    'zone_id' => $this->zone->id,
                    'quantity' => $stock['add'],
                ]);
            }
            // ProductZoneHistory
            ProductZoneHistory::create([
                'product_id' => $key,
                'zone_id' => $this->zone->id,
                'quantity' => $stockToAdd,
                'quantity_before' => $quantity_before,
                'action' => 'add',
                'updated_by_id' => auth()->id(),
            ]);
        }
        $this->state['stock'] = [];

        // dispatch success alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Stock added successfully',
        ]);
    }
    // protected function rules(): array
    // {
    //     return [
    //         'productZonePivot.product_id' => [
    //             'integer',
    //             'exists:products,id',
    //             'nullable',
    //         ],
    //         'productZonePivot.zone_id' => [
    //             'integer',
    //             'exists:zones,id',
    //             'nullable',
    //         ],
    //         'productZonePivot.quantity' => [
    //             'integer',
    //             'min:-2147483648',
    //             'max:2147483647',
    //             'nullable',
    //         ],
    //         'productZonePivot.price' => [
    //             'numeric',
    //             'nullable',
    //         ],
    //         'productZonePivot.last_updated_by_id' => [
    //             'integer',
    //             'exists:users,id',
    //             'nullable',
    //         ],
    //     ];
    // }
}
