<?php

namespace App\Http\Livewire\ZonalOfficer\Task;

use App\Models\Client;
use App\Models\ClientBranch;
use App\Models\ClientGroup;
use App\Models\Task;
use App\Models\TaskStatus;
use App\Models\TaskTag;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class Create extends Component
{
    public Task $task;

    public array $tag = [];

    public array $mediaToRemove = [];

    public array $listsForFields = [];

    public array $mediaCollections = [];

    public function addMedia($media): void
    {
        $this->mediaCollections[$media['collection_name']][] = $media;
    }

    public function removeMedia($media): void
    {
        $collection = collect($this->mediaCollections[$media['collection_name']]);

        $this->mediaCollections[$media['collection_name']] = $collection->reject(fn ($item) => $item['uuid'] === $media['uuid'])->toArray();

        $this->mediaToRemove[] = $media['uuid'];
    }

    public function mount(Task $task)
    {
        $this->task = $task;
        $this->task->status_id = 1;
        $this->initListsForFields();
    }
    // public function updated()
    // {
    //     // $this->emit('hydrated');
    //     $this->dispatchBrowserEvent('hydrated', []);
    // }

    public function render()
    {
        return view('livewire.zonal-officer.task.create');
    }

    public function submit()
    {
        $this->validate();

        $this->task->save();
        $this->task->tag()->sync($this->tag);
        $this->syncMedia();

        return redirect()->route('co.tasks.index');
    }

    protected function syncMedia(): void
    {
        collect($this->mediaCollections)->flatten(1)
            ->each(fn ($item) => Media::where('uuid', $item['uuid'])
                ->update(['model_id' => $this->task->id]));

        Media::whereIn('uuid', $this->mediaToRemove)->delete();
    }

    protected function rules(): array
    {
        return [
            'task.name' => [
                'string',
                'required',
            ],
            'task.description' => [
                'string',
                'nullable',
            ],
            'task.status_id' => [
                'integer',
                'exists:task_statuses,id',
                'required',
            ],
            'tag' => [
                'array',
            ],
            'tag.*.id' => [
                'integer',
                'exists:task_tags,id',
            ],
            'mediaCollections.task_attachment' => [
                'array',
                'nullable',
            ],
            'mediaCollections.task_attachment.*.id' => [
                'integer',
                'exists:media,id',
            ],
            'task.due_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'task.assigned_to_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'task.client_group_id' => [
                'integer',
                'exists:client_groups,id',
                'nullable',
            ],
            'task.client_id' => [
                'integer',
                'exists:clients,id',
                'nullable',
            ],
            'task.client_branch_id' => [
                'integer',
                'exists:client_branches,id',
                'nullable',
            ],
            'task.call_type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['call_type'])),
            ],
            'task.incode' => [
                'string',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $user = Auth::user();
        $this->listsForFields['status']        = TaskStatus::pluck('name', 'id')->toArray();
        $this->listsForFields['tag']           = TaskTag::pluck('name', 'id')->toArray();
        $this->listsForFields['assigned_to']   = User::pluck('name', 'id')->toArray();
        $this->listsForFields['client_group']  = ClientGroup::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_group']  = $user->clientGroups()->pluck('name', 'id')->toArray();
        // $this->listsForFields['client']        = Client::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_branch'] = ClientBranch::pluck('name', 'id')->toArray();
        $this->listsForFields['client']        = [];
        $this->listsForFields['client_branch'] = [];
        $this->listsForFields['call_type']     = $this->task::CALL_TYPE_RADIO;

        // if ($this->task->client_group_id == null && count($this->listsForFields['client_group']) > 0) {
        //     $this->task->client_group_id = array_key_first($this->listsForFields['client_group']);
        //     $this->updatedTask($this->task->client_group_id, "client_group_id");
        // }
    }


    public function updatedTask($value, $key)
    {
        // dump($value, $key);
        if ($key == "client_group_id") {
            if ($value) {
                $cg = ClientGroup::with('clients')->find($value);
                $this->listsForFields['client'] = $cg->clients()->pluck('name', 'id')->toArray();
            } else {
                $this->task->client_id = null;
                $this->task->client_branch_id = null;
                $this->listsForFields['client'] = [];
                $this->listsForFields['client_branch'] = [];
            }
        } elseif ($key == "client_id") {
            if ($value) {
                $cl = Client::with(['clientBranches', 'clientBranches.circle'])->find($value);
                $this->listsForFields['client_branch'] = $cl->clientBranches->pluck('name_circle', 'id')->toArray();
            } else {
                $this->listsForFields['client_branch'] = [];
            }
        }
    }
}
