<?php

namespace App\Http\Livewire\VisitRoute;

use App\Models\User;
use App\Models\VisitReimbursement;
use App\Models\VisitRoute;
use Livewire\Component;

class Edit extends Component
{
    public VisitRoute $visitRoute;

    public array $listsForFields = [];

    public function mount(VisitRoute $visitRoute)
    {
        $this->visitRoute = $visitRoute;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.visit-route.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->visitRoute->save();

        return redirect()->route('admin.visit-routes.index');
    }

    protected function rules(): array
    {
        return [
            'visitRoute.from' => [
                'string',
                'max:255',
                'nullable',
            ],
            'visitRoute.to' => [
                'string',
                'max:255',
                'nullable',
            ],
            'visitRoute.journey_distance' => [
                'numeric',
                'nullable',
            ],
            'visitRoute.journey_fare' => [
                'numeric',
                'nullable',
            ],
            'visitRoute.vehicle_type' => [
                'required',
                'in:' . implode(',', array_keys($this->listsForFields['vehicle_type'])),
            ],
            'visitRoute.journey_type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['journey_type'])),
            ],
            'visitRoute.note' => [
                'string',
                'nullable',
            ],
            'visitRoute.route_cost' => [
                'numeric',
                'nullable',
            ],
            'visitRoute.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'visitRoute.reimbursement_id' => [
                'integer',
                'exists:visit_reimbursements,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['vehicle_type']  = $this->visitRoute::VEHICLE_TYPE_RADIO;
        $this->listsForFields['journey_type']  = $this->visitRoute::JOURNEY_TYPE_RADIO;
        $this->listsForFields['user']          = User::pluck('name', 'id')->toArray();
        $this->listsForFields['reimbursement'] = VisitReimbursement::pluck('amount', 'id')->toArray();
    }
}
