<?php

namespace App\Http\Livewire\VisitReimbursement;

use App\Models\EmployeeAttendanceLog;
use App\Models\Task;
use App\Models\User;
use App\Models\VisitReimbursement;
use Livewire\Component;

class Edit extends Component
{
    public array $listsForFields = [];
    public array $routesArr = [];

    public VisitReimbursement $visitReimbursement;

    public function mount(VisitReimbursement $visitReimbursement)
    {
        $this->visitReimbursement = $visitReimbursement;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.visit-reimbursement.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->visitReimbursement->save();

        return redirect()->route('admin.visit-reimbursements.index');
    }

    protected function rules(): array
    {
        return [
            'visitReimbursement.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'visitReimbursement.task_id' => [
                'integer',
                'exists:tasks,id',
                'nullable',
            ],
            'visitReimbursement.approved_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'visitReimbursement.approved_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
            'visitReimbursement.amount' => [
                'numeric',
                'nullable',
            ],
            'visitReimbursement.visit_id' => [
                'integer',
                'exists:employee_attendance_logs,id',
                'nullable',
            ],
            'visitReimbursement.status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['status'])),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['user']        = User::pluck('name', 'id')->toArray();
        $this->listsForFields['task']        = Task::pluck('name', 'id')->toArray();
        $this->listsForFields['approved_by'] = User::pluck('name', 'id')->toArray();
        $this->listsForFields['visit']       = EmployeeAttendanceLog::pluck('date', 'id')->toArray();
        $this->listsForFields['status']      = $this->visitReimbursement::STATUS_RADIO;
    }
}
