<?php

namespace App\Http\Livewire\User;

use App\Models\EmployeeEducationalInfo;
use App\Models\EmployeeFamilyDetail;
use App\Models\EmployeeInfo;
use App\Models\JobDesignation;
use App\Models\User;
use Illuminate\Support\Arr;
use Livewire\Component;

class EmployeeDetailsUpdate extends Component
{
    public array $listsForFields = [];

    public EmployeeInfo $employeeInfo;
    public User $user;
    public $empEducInfos = [[]];
    public $empFamDet = [[]];

    protected function getListeners()
    {
        return [
            'removeEducationalDetailRow' => 'removeEducationalDetailRow',
            'removeFamilyDetailRow' => 'removeFamilyDetailRow',
        ];
    }
    public function mount(User $user)
    // public function mount(EmployeeInfo $employeeInfo)
    {
        $this->user = $user;
        if (!isset($user->employeeDetails)) {
            $this->employeeInfo              = new  EmployeeInfo;
            $this->employeeInfo->user_id     = $user->id;
        } else {
            $this->employeeInfo              = $user->employeeDetails;
        }
        $this->employeeInfo->citizenship = 'indian';
        $this->initListsForFields();
        $this->loadAdditionalDetailsFromDb();
    }

    public function loadAdditionalDetailsFromDb()
    {
        // educationalDetails familyDetails
        if ($this->user && $this->user->employeeDetails) {
            $empEducInfos = $this->user->employeeDetails->educationalDetails;
            if ($empEducInfos->count() > 0) {
                $this->empEducInfos = $empEducInfos->toArray();
            }
            $empFamDet = $this->user->employeeDetails->familyDetails;
            if ($empFamDet->count() > 0) {
                $this->empFamDet = $empFamDet->toArray();
            }
        }
    }

    public function render()
    {
        return view('livewire.user.employee-details-update');
    }

    public function submit()
    {
        $this->validate();

        $this->employeeInfo->save();

        if (count($this->empEducInfos) > 0) {
            foreach ($this->empEducInfos as  $item) {
                $updatable = Arr::has($item, 'id');
                if ($updatable) {
                    $id = Arr::get($item, 'id');
                    try {
                        $eloqObj = EmployeeEducationalInfo::find($id);
                        $eloqObj->update($item);
                    } catch (\Throwable $th) {
               report($th);
                        //throw $th;
                    }
                } else {
                    $this->employeeInfo->educationalDetails()->create($item);
                }
            }
        }

        if (count($this->empFamDet) > 0) {
            foreach ($this->empFamDet as  $item) {
                $updatable = Arr::has($item, 'id');
                if ($updatable) {
                    $id = Arr::get($item, 'id');
                    try {
                        $eloqObj = EmployeeFamilyDetail::find($id);
                        $eloqObj->update($item);
                    } catch (\Throwable $th) {
               report($th);
                        //throw $th;
                    }
                } else {
                    $this->employeeInfo->familyDetails()->create($item);
                }
            }
        }

        return redirect()->route('admin.user.employee-details', [$this->user]);
    }

    protected function rules(): array
    {
        return [
            'employeeInfo.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'employeeInfo.first_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.middle_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.last_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.gender' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['gender'])),
            ],
            'employeeInfo.dob' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'employeeInfo.citizenship' => [
                'string',
                'nullable',
            ],
            'employeeInfo.age' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.religion' => [
                'string',
                'nullable',
            ],
            'employeeInfo.maritial_status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['maritial_status'])),
            ],
            'employeeInfo.blood_group' => [
                'string',
                'nullable',
            ],
            'employeeInfo.email' => [
                'email:rfc',
                'nullable',
            ],
            'employeeInfo.present_address_line_1' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_2' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_3' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_line_4' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_district' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_pin' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_state' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_address_landmark' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_1' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_2' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_3' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_line_4' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_district' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_pin' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_state' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_address_landmark' => [
                'string',
                'nullable',
            ],
            'employeeInfo.personal_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.present_residence_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.permanent_residence_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_relation' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_1_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_name' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_relation' => [
                'string',
                'nullable',
            ],
            'employeeInfo.emergency_contact_2_phone' => [
                'string',
                'nullable',
            ],
            'employeeInfo.doj' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'employeeInfo.department' => [
                'string',
                'nullable',
            ],
            'employeeInfo.job_desgination_id' => [
                'integer',
                'exists:job_designations,id',
                'nullable',
            ],
            'employeeInfo.esic' => [
                'string',
                'nullable',
            ],
            'employeeInfo.uan' => [
                'string',
                'nullable',
            ],
            'employeeInfo.aadhaar' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_no' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_bank' => [
                'string',
                'nullable',
            ],
            'employeeInfo.salary_ac_ifsc' => [
                'string',
                'nullable',
            ],
            'employeeInfo.pm_basic_salary' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_hra' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_pf' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_esic' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.pm_ptax' => [
                'numeric',
                'nullable',
            ],
            'employeeInfo.payment_mode' => [
                'string',
                'nullable',
            ],
            'employeeInfo.location' => [
                'string',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['user']            = User::pluck('name', 'id')->toArray();
        $this->listsForFields['gender']          = $this->employeeInfo::GENDER_RADIO;
        $this->listsForFields['maritial_status'] = $this->employeeInfo::MARITIAL_STATUS_SELECT;
        $this->listsForFields['job_desgination'] = JobDesignation::pluck('title', 'id')->toArray();
        $this->listsForFields['course_type']   = EmployeeEducationalInfo::COURSE_TYPE_RADIO;
        $this->listsForFields['relation']      = EmployeeFamilyDetail::RELATION_RADIO;
    }


    public function addEducationalDetailRow()
    {
        $this->empEducInfos[] = [];
    }
    public function removeEducationalDetailRow($index)
    {
        //check if id exists in element, if yes delete from eloquent also
        $elm = Arr::get($this->empEducInfos, $index);
        if ($elm && Arr::has($elm, 'id')) {
            $id = $elm['id'];
            try {
                $eloqObj = EmployeeEducationalInfo::find($id);
                $eloqObj->delete();
            } catch (\Throwable $th) {
               report($th);
                //throw $th;
            }
        }
        $this->empEducInfos = collect($this->empEducInfos)
            ->filter(function ($d, $i) use ($index) {
                return $i != $index;
            })
            ->toArray()
            //
        ;
    }

    public function addFamilyDetailRow()
    {
        $this->empFamDet[] = [];
    }
    public function removeFamilyDetailRow($index)
    {
        //check if id exists in element, if yes delete from eloquent also
        $elm = Arr::get($this->empFamDet, $index);
        if ($elm && Arr::has($elm, 'id')) {
            $id = $elm['id'];
            try {
                $eloqObj = EmployeeFamilyDetail::find($id);
                $eloqObj->delete();
            } catch (\Throwable $th) {
               report($th);
                //throw $th;
            }
        }
        $this->empFamDet = collect($this->empFamDet)
            ->filter(function ($d, $i) use ($index) {
                return $i != $index;
            })
            ->toArray()
            //
        ;
    }
}
