<?php

namespace App\Http\Livewire\Task;

use App\Models\Task;
use App\Models\TaskEventLog;
use App\Models\TaskStatus;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class TaskTimelineModalComponent extends ModalComponent
{
    public Task $task;
    public User $user;
    public $description;

    // public $accordion1Id = null;


    public  $engineers = [];
    public  $listsForFields = [
        'engineers' => []
    ];

    // public $assigned_to_id = null;
    // public $status_id = null;


    public static function modalMaxWidth(): string
    {
        return 'lg';
    }

    public function mount($taskId)
    {
        $user = Auth::user();
        $task = Task::find($taskId);
        $task->load([
            'status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch',
            'taskEventLogs.loggedBy',
            'taskEventLogs.assignedTo',
        ]);

        $this->task = $task;
        $this->user = $user;

        // $this->engineers = (array) $user->engineers;
        $this->initListsForFields();
    }
    public function render()
    {
        return view('livewire.task.task-timeline-modal-component', [
            'accordion1Id' => "accordx-".uniqid(),
        ]);
    }



    protected function initListsForFields(): void
    {
        // $this->listsForFields['engineers'] = $this->user->engineers->mapWithKeys(function ($d) {
        //     return [$d->id => $d->name_role];
        // });
        $this->listsForFields['status']        = TaskStatus::pluck('name', 'id')->toArray();
        // $this->listsForFields['tag']           = TaskTag::pluck('name', 'id')->toArray();
        // $this->listsForFields['assigned_to']   = User::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_group']  = ClientGroup::pluck('name', 'id')->toArray();
        // $this->listsForFields['client']        = Client::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_branch'] = ClientBranch::pluck('name', 'id')->toArray();
        // $this->listsForFields['call_type']     = $this->task::CALL_TYPE_RADIO;
    }


    protected function rules(): array
    {
        return [
            'task.status_id' => [
                'integer',
                'exists:task_statuses,id',
                'required',
            ],
            'description' => [
                'string',
                'nullable'
            ],
            // 'task.assigned_to_id' => [
            //     'integer',
            //     'exists:users,id',
            //     'required',
            // ],
        ];
    }

    public function submit()
    {
        $oldStatus = $this->task->status;
        $vals =  $this->validate();
        $this->task->update($vals['task']);
        $this->task->refresh()->load(['status']);
        TaskEventLog::createStatusChangedEvent(
            $this->task,
            auth()->user(),
            $this->description,
            $oldStatus,
            $this->task->status
        );
        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
            TaskShowEngineer::getName() => ['taskModified', [$this->task->id]]
        ]);
    }

    public function cancel()
    {
        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
        ]);
    }
}
