<?php

namespace App\Http\Livewire\Task;

use App\Http\Livewire\CircleOfficer\Task\TaskShowCo;
use App\Http\Livewire\ZonalOfficer\Task\TaskShowZo;
use App\Models\Task;
use App\Models\TaskEventLog;
use App\Models\TaskStatus;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class TaskBillingModalComponent extends ModalComponent
{
    public Task $task;
    public Task $taskOld;
    public User $user;
    public $description;


    public  $engineers = [];
    public  $listsForFields = [
        'engineers' => []
    ];

    // public $assigned_to_id = null;
    // public $status_id = null;


    public static function modalMaxWidth(): string
    {
        return 'xl';
    }

    public function mount($taskId)
    {
        $user = Auth::user();
        $task = Task::find($taskId);
        $task->load('status', 'tag', 'assignedTo', 'clientGroup', 'client', 'clientBranch');

        $this->task = $task;
        $this->task->is_invoiceable = $this->task->is_invoiceable ?? false;
        $this->task->igst_rate = $this->task->igst_rate ?? 18;
        // $this->taskOld = $this->task;
        $this->user = $user;

        // $this->engineers = (array) $user->engineers;
        $this->initListsForFields();
    }
    public function render()
    {
        return view('livewire.task.task-billing-modal-component');
    }



    protected function initListsForFields(): void
    {
        // $this->listsForFields['engineers'] = $this->user->engineers->mapWithKeys(function ($d) {
        //     return [$d->id => $d->name_role];
        // });
        // $this->listsForFields['status']        = TaskStatus::pluck('name', 'id')->toArray();
        // $this->listsForFields['tag']           = TaskTag::pluck('name', 'id')->toArray();
        // $this->listsForFields['assigned_to']   = User::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_group']  = ClientGroup::pluck('name', 'id')->toArray();
        // $this->listsForFields['client']        = Client::pluck('name', 'id')->toArray();
        // $this->listsForFields['client_branch'] = ClientBranch::pluck('name', 'id')->toArray();
        // $this->listsForFields['call_type']     = $this->task::CALL_TYPE_RADIO;
    }


    protected function rules(): array
    {
        return [
            'task.is_invoiceable' => [
                'boolean',
            ],
            'task.amount_w_gst' => [
                'numeric',
            ],
            'task.amount_wo_gst' => [
                'numeric',
            ],
            'task.igst_rate' => [
                'numeric',
            ],
            'task.hsn_code' => [
                'numeric',
            ],
        ];
    }

    public function submit()
    {
        // $oldStatus = $this->taskOld->status;
        $vals =  $this->validate();
        $this->calculateAllTaxInfos();

        $this->task->update($vals['task']);


        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
            TaskShowEngineer::getName() => ['taskModified', [$this->task->id]],
            TaskShowCo::getName() => ['taskModified', [$this->task->id]],
            TaskShowZo::getName() => ['taskModified', [$this->task->id]],
            TaskShowAdmin::getName() => ['taskModified', [$this->task->id]],
        ]);
    }

    public function cancel()
    {
        $this->closeModalWithEvents([
            // UserOverview::getName() => ['userModified', [$this->user->id]],
        ]);
    }

    public function updatedTask($value, $key)
    {
        //keys: is_invoiceable amount_w_gst amount_wo_gst igst_rate
        // if key any of  amount_wo_gst, igst_rate calculateAmountWithGST
        // if key any of  amount_w_gst, igst_rate calculateAmountWithoutGST


        if ($key == 'amount_wo_gst' || $key == 'igst_rate') {
            $this->task->amount_w_gst = $this->calculateAmountWithGST($this->task->igst_rate, $this->task->amount_wo_gst);
        }
        if ($key == 'amount_w_gst' || $key == 'igst_rate') {
            $this->task->amount_wo_gst = $this->calculateAmountWithoutGST($this->task->igst_rate, $this->task->amount_w_gst);
        }

        $this->calculateAllTaxInfos();
    }

    function calculateAllTaxInfos()
    {
        // calculate and fill 'cgst_rate', 'sgst_rate', 'igst_amount', 'cgst_amount', 'sgst_amount', 'gst_amount', 'gst_details'(array)
        $this->task->cgst_rate = $this->task->igst_rate / 2;
        $this->task->sgst_rate = $this->task->igst_rate / 2;
        $this->task->igst_amount = $this->task->amount_w_gst - $this->task->amount_wo_gst;
        $this->task->cgst_amount = $this->task->igst_amount / 2;
        $this->task->sgst_amount = $this->task->igst_amount / 2;
        $this->task->gst_amount = $this->task->igst_amount;
        $this->task->gst_details = [
            'igst_rate' => $this->task->igst_rate,
            'cgst_rate' => $this->task->cgst_rate,
            'sgst_rate' => $this->task->sgst_rate,
            'igst_amount' => $this->task->igst_amount,
            'cgst_amount' => $this->task->cgst_amount,
            'sgst_amount' => $this->task->sgst_amount,
            'gst_amount' => $this->task->gst_amount,
        ];
    }

    public function calculateAmountWithGST($gstRate, $amountWithoutGst)
    {
        return calculateAmountWithTax($gstRate, $amountWithoutGst);
        // return number_format($amountWithoutGst + ($amountWithoutGst * $gstRate / 100), 2);
    }

    public function calculateAmountWithoutGST($gstRate, $amountWithGst)
    {
        return calculateAmountWithoutTax($gstRate, $amountWithGst);
        // return number_format($amountWithGst / (1 + ($gstRate / 100)), 2);
    }
}
