<?php

namespace App\Http\Livewire\State;

use App\Models\Region;
use App\Models\State;
use App\Models\Zone;
use Livewire\Component;

class Edit extends Component
{
    public State $state;

    public array $listsForFields = [];

    public function mount(State $state)
    {
        $this->state = $state;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.state.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->state->save();

        return redirect()->route('admin.states.index');
    }

    protected function rules(): array
    {
        return [
            'state.name' => [
                'string',
                'nullable',
            ],
            'state.is_active' => [
                'boolean',
            ],
            'state.region_id' => [
                'integer',
                'exists:regions,id',
                'nullable',
            ],
            // 'state.zone_id' => [
            //     'integer',
            //     'exists:zones,id',
            //     'nullable',
            // ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['regions'] = Region::pluck('name', 'id')->toArray();
        // $this->listsForFields['zone'] = Zone::pluck('name', 'id')->toArray();
    }
}
