<?php

namespace App\Http\Livewire\Service;

use App\Models\Service;
use Livewire\Component;

class Create extends Component
{
    public Service $service;

    public function mount(Service $service)
    {
        $this->service = $service;
    }

    public function render()
    {
        return view('livewire.service.create');
    }

    public function submit()
    {
        $this->validate();

        $this->service->save();

        return redirect()->route('admin.services.index');
    }

    protected function rules(): array
    {
        return [
            'service.name' => [
                'string',
                'nullable',
            ],
            'service.description' => [
                'string',
                'nullable',
            ],
            'service.price' => [
                'numeric',
                'nullable',
            ],

            /* 'hsn_code', 'gst_rate', 'cgst_rate', 'sgst_rate', 'igst_rate', 'taxable_price', */

            'service.hsn_code' => [
                'string',
                'required',
            ],
            'service.gst_rate' => [
                'numeric',
                // 'required',
            ],
            'service.cgst_rate' => [
                'numeric',
                // 'required',
            ],
            'service.sgst_rate' => [
                'numeric',
                // 'required',
            ],
            'service.igst_rate' => [
                'numeric',
                // 'required',
            ],
            'service.taxable_price' => [
                'numeric',
                // 'required',
            ],

        ];
    }

    public function updatedService($value, $key)
    {
        if (in_array($key, ["gst_rate", "taxable_price", "price"])) {
            $this->calculatePrice();
        }
    }

    public function calculatePrice()
    {
        $gst_rate = floatval($this->service->gst_rate);
        $taxable_price = floatval($this->service->taxable_price);

        // price = taxable_price +(taxable_price * (gst_rate /100))
        $this->service->price = standard_number_format($taxable_price + ($taxable_price * ($gst_rate / 100)));

        $this->service->cgst_rate = standard_number_format($gst_rate / 2);
        $this->service->sgst_rate = standard_number_format($gst_rate / 2);
        $this->service->igst_rate = standard_number_format($gst_rate);
    }
}
