<?php

namespace App\Http\Livewire\Region;

use App\Models\Circle;
use App\Models\Region;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Create extends Component
{
    public Region $region;

    public array $engineer = [];

    public array $listsForFields = [];

    public function mount(Region $region)
    {
        $this->region            = $region;
        $this->region->is_active = true;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.region.create');
    }

    public function submit()
    {
        $this->validate();

        $this->region->save();
        // $this->region->engineer()->sync($this->engineer);

        return redirect()->route('admin.regions.index');
    }

    protected function rules(): array
    {
        return [
            'region.name' => [
                'string',
                'nullable',
            ],
            'region.is_active' => [
                'boolean',
            ],
            // 'region.circle_id' => [
            //     'integer',
            //     'exists:circles,id',
            //     'nullable',
            // ],
            // 'engineer' => [
            //     'array',
            // ],
            // 'engineer.*.id' => [
            //     'integer',
            //     'exists:users,id',
            // ],
        ];
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['circle']   = Circle::pluck('name', 'id')->toArray();
        // $this->listsForFields['engineer'] = User::pluck('name', 'id')->toArray();

        // $this->listsForFields['circle']   = Circle::pluck('name', 'id')->toArray();


        // $userIds =  DB::table('role_user')->select('user_id')->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();

        // // $this->listsForFields['engineer'] = User::whereIn('id', $userIds)->pluck('name', 'id')->toArray();
        // // $this->listsForFields['engineer'] = User::with('roles')->whereIn('id', $userIds)->pluck('name', 'id','roles.title')->toArray();
        // $engineers = User::with('roles')->whereIn('id', $userIds)->get();
        // $engineersArr = $engineers->mapWithKeys(function ($u) {
        //     return [$u->id => $u->name . "  (" . $u->roles[0]->title . ")"];
        // });
        // $this->listsForFields['engineer'] = $engineersArr;
    }
}
