<?php

namespace App\Http\Livewire\Purchase;

use App\Models\Purchase;
use Livewire\Component;
use App\Models\Product;
use App\Models\Ledger;
use Illuminate\Support\Arr;

class Create extends Component
{
    public Purchase $purchase;
    public Ledger $ledger;
    public array $listsForFields = [];

    public $srhItem;
    public  $invItems;
    public $addeditem = [];
    public $addtax = [];
    public $subtotal = 0;
    public $LedgerGroup = [];
    public $ledgerattres = [];
    public $ledgerattrvalues = [];
    public $taxledgers;
    public $ledgers;
    public $distnttaxrate = [];


    public function mount(Purchase $purchase, Ledger $ledger)
    {
        $this->purchase = $purchase;
        $this->initListsForFields();
        $this->srhitem = "";
        $this->resetall();
        $this->ledger = $ledger;
    }
    public function updatedAddeditem($value, $key)
    {


        [$indx, $aKey] = explode('.', $key);

        foreach ($this->invItems as $key => $ivalue) {
            if ($ivalue['id'] == $indx) {
                // dump($this->invItems[$key]['name']);
                $this->invItems[$key]['qnty'] = $value;
                // $this->invItems['qnty']= intval($value);
                $this->invItems[$key]['total'] = floatval(intval($this->invItems[$key]['price']) * intval($value));
            }
        }
        // if ($aKey == "qnty") {
        //     // ...
        //     $price = floatval($this->addeditem[$indx]['price']);
        //     $qty = intval($value);
        //     $this->addeditem[$indx]['total'] = $price * $qty;
        // }
        $this->resetTax();
        $this->evaluteInvtotl();
    }
    public function resetall()
    {
        $this->srhItem = "";
        if (empty(trim($this->srhItem))) {
            return collect();
        }
    }

    public function getSearchItems()
    {
        if (empty(trim($this->srhItem))) {
            return collect();
        }
        return Product::where('name', 'like', '%' . $this->srhItem . '%')
            ->get();
    }
    public function render()
    {
        return view('livewire.purchase.create', [
            'items' => $this->getSearchItems(),
        ]);
    }

    public function submit()
    {
        $this->validate();

        $this->purchase->save();

        return redirect()->route('admin.purchases.index');
    }

    protected function rules(): array
    {
        return [
            'purchase.suply_invc_no' => [
                'string',
                'min:15',
                'nullable',
            ],
            'purchase.prchs_date' => [
                'nullable',
                'date_format:' . config('project.date_format'),
            ],
            'purchase.party_ac' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['party_ac'])),
            ],
            'purchase.total_invoic' => [
                'numeric',
                'nullable',
            ],
            'purchase.csgt_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.sgst_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.igst_amt' => [
                'numeric',
                'nullable',
            ],
            'purchase.invoice_total_wo_tax' => [
                'numeric',
                'nullable',
            ],
            'purchase.details' => [
                'string',
                'min:20',
                'nullable',
            ],
            'ledger.name' => [
                'string',
                'nullable',
            ],
            'ledger.description' => [
                'string',
                'nullable',
            ],
            'ledger.ledger_group_id' => [
                'integer',
                'exists:ledger_groups,id',
                'required',
            ],
            // 'ledger.ledger_id' => [
            //     'integer',
            //     'exists:ledger,id',
            //     'required',
            // ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['party_ac'] = $this->purchase::PARTY_AC_SELECT;
        $this->listsForFields['ledger_group'] = Ledger::whereIn('ledger_group_id', ["3", "4"])->pluck('name', 'id')->toArray();
    }

    public function updateItemqntyChngEvt($id)
    {
        $this->addeditem[$id]['qnty'] = $this->itmqntity;
    }

    public function addItemClickEvt($id)
    {
        //    dump($id);
        //    return;


        // $invItem = [];
        $this->addeditem[$id] = [
            "qnty" => 1,
            "price" => 0,
            "total" => 0
        ];

        // dump(array_keys($this->addeditem));
        // return;
        $fitem = Product::with(['taxLedgers'])->whereIn('id', array_keys($this->addeditem))->get();
        $this->invItems = $fitem->toArray();
        foreach ($this->invItems as $key => $value) {


            $this->invItems[$key]['tax_ledger_rate_assoc'] = collect($this->invItems[$key]['tax_ledgers'])->mapWithKeys(fn ($l) => [$l['id'] => Arr::get($l, 'pivot.rate')]);
            $this->invItems[$key]['qnty'] = $this->addeditem[$value['id']]['qnty'];
            $this->addeditem[$value['id']]['price'] = $value['price'];
            $this->addeditem[$value['id']]['total'] = floatval(intval($this->addeditem[$value['id']]['qnty']) * intval($value['price']));

            // $this->invItems[$key]['price']=$value['price'];
            $this->invItems[$key]['total'] = floatval(intval($this->addeditem[$value['id']]['qnty']) * intval($value['price']));
        }

        // array_push($this->invItems,$id);

        // dump($this->invItems);
        // $this->invItems = $id;
        $this->evaluteInvtotl();
    }
    public function deltItemClickEvt($id)
    {
        foreach ($this->invItems as $key => $value) {
            if ($value['id'] == $id) {
                unset($this->addeditem[$id]);
                unset($this->invItems[$key]);
            }
        }
        $this->evaluteInvtotl();
    }


    public function updatedLedger($value, $key)
    {
        //dump($this->ledger->ledger_group_id);
        // $this->city_id = LgAttribute::with(['ledgerGroup']);
        if ($key == "ledger_group_id") {



            // $this->reset('ledegr_group_attributes');
            // // $this->ledegr_group_attributes=[];
            // $this->lg_attributes = LedgerGroup::with(['ledgerattres', 'ledgerattres.ledgerattrvalues'])->find($this->ledger->ledger_group_id);

            //   dump(Ledger::with(['LedgerGroup', 'ledgerattres.ledgerattrvalues'])->find($this->ledger->ledger_group_id));
            $this->ledgers = Ledger::with(['LedgerGroup'])->find($this->ledger->ledger_group_id);
            if ($this->ledgers->LedgerGroup->name == "Sundry Creditors") {
                // $taxledgers=Ledger::with(['LedgerGroup', 'ledgerattres.ledgerattrvalues'])->find($this->ledger->ledger_group_id);
                $this->taxledgers = Ledger::with(['ledgerGroup.ledgerattres.ledgerattrvalues'])
                    ->where('ledger_group_id', '=', 1)->get();
                // dump($taxledgers);



            }
            //   dump($this->ledger->LedgerGroup->name);
        }
    }

    public function addtaxClickEvt()
    {
        // $this->addtax[count($this->addtax) + 1] = [
        //     "ldger_id" => '',
        //     "ledger_name" => '',
        //     "amont" => 0
        // ];

        $this->addtax[] = [
            // "ldger_id" => '',
            // "ledger_name" =>'',
            "amont" => 0
        ];
    }



    public function updatedaddtax($value, $key)
    {
        // dump($key);
        // $price = Arr::get($array, 'products.desk.price');
        foreach ($this->invItems as $itmkey => $itmvalue) {
            // dd($itmvalue);
            if (array_key_exists('tax_ledger_rate_assoc', $itmvalue)) {
                $taxrate = Arr::get($itmvalue, 'tax_ledger_rate_assoc.' . $value);

                if (array_key_exists($value, $this->distnttaxrate)) {
                    // if ($this->distnttaxrate[$value]['txrt'] == $taxrate) {
                    //     $this->distnttaxrate[$value]['ptotal'] = $this->distnttaxrate[$value]['ptotal'] + $itmvalue->total;
                    // }
                    // if (!is_array($this->distnttaxrate[$value])) {
                    //     $this->distnttaxrate[$value] = [];
                    // }
                    if (!array_key_exists($taxrate, $this->distnttaxrate[$value])) {
                        $this->distnttaxrate[$value][$taxrate] = 0;
                    }
                    $this->distnttaxrate[$value][$taxrate] = $this->distnttaxrate[$value][$taxrate] + $itmvalue['total'];
                } else {
                    // $this->distnttaxrate[$value]=[
                    //     "txrt"=>$taxrate,
                    //     "ptotal"=>$itmvalue->total
                    // ];
                    $this->distnttaxrate[$value] = [
                        $taxrate => $itmvalue['total']

                    ];
                }
            }
        }
        $this->calculateTax();
        $this->evaluteInvtotl();
    }

    public function calculateTax()
    {

        foreach ($this->distnttaxrate as $itmkey => $itmvalue) {
            // dump($itmvalue);
            $totalamount = 0;
            foreach ($itmvalue as $itmvaluekey => $itmvaluevalue) {
                // dump($itmvaluevalue);
                $taxableamount=($itmvaluevalue/100)*$itmvaluekey;
                $totalamount = $totalamount + $taxableamount;
            }
            // $ledgrtax=collect($this->addtax)->where('ledger_id', $itmkey)->first();
            // $ledgrtax['amont']=$totalamount;
            // dd($totalamount);
            foreach ($this->addtax as $itmaddtax => $itmvalueaddtax) {
                // dump($itmvaluevalue);

                if (isset($itmvalueaddtax['ledger_id']) && $itmvalueaddtax['ledger_id'] == $itmkey) {
                    $this->addtax[$itmaddtax]['amont'] = $totalamount;
                }
            }
        }


    }
    public function evaluteInvtotl()
    {
        $this->subtotal = 0;
        foreach ($this->invItems as $key => $value) {

            $this->subtotal = floatval($this->subtotal) + floatval($this->invItems[$key]['total']);
        }
        if(isset($this->addtax))
        {
            foreach ($this->addtax as $itmaddtax => $itmvalueaddtax) {
                // dump($itmvaluevalue);


                $this->subtotal = $this->subtotal + floatval($this->addtax[$itmaddtax]['amont']);

            }
        }




    }

    public function resetTax(){
        $this->addtax=[];
        $this->distnttaxrate = [];
    }
}
