<?php

namespace App\Http\Livewire\ProductZonePivot;

use App\Models\Product;
use App\Models\ProductZonePivot;
use App\Models\User;
use App\Models\Zone;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public ProductZonePivot $productZonePivot;

    public function mount(ProductZonePivot $productZonePivot)
    {
        $this->productZonePivot           = $productZonePivot;
        $this->productZonePivot->quantity = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.product-zone-pivot.create');
    }

    public function submit()
    {
        $this->validate();

        $this->productZonePivot->save();

        return redirect()->route('admin.product-zone-pivots.index');
    }

    protected function rules(): array
    {
        return [
            'productZonePivot.product_id' => [
                'integer',
                'exists:products,id',
                'nullable',
            ],
            'productZonePivot.zone_id' => [
                'integer',
                'exists:zones,id',
                'nullable',
            ],
            'productZonePivot.quantity' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'productZonePivot.price' => [
                'numeric',
                'nullable',
            ],
            'productZonePivot.last_updated_by_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['zone']            = Zone::pluck('name', 'id')->toArray();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
    }
}
