<?php

namespace App\Http\Livewire\Product;

use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductTag;
use Livewire\Component;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use App\Models\Ledger;

class Edit extends Component
{
    public array $tag = [];

    public Product $product;

    public array $category = [];

    public array $mediaToRemove = [];

    public array $listsForFields = [];

    public array $mediaCollections = [];

    public array $tax_ledger_group;
    public $addtax = [];
    public $selectedTax = [];

    public function addMedia($media): void
    {
        $this->mediaCollections[$media['collection_name']][] = $media;
    }

    public function removeMedia($media): void
    {
        $collection = collect($this->mediaCollections[$media['collection_name']]);

        $this->mediaCollections[$media['collection_name']] = $collection->reject(fn ($item) => $item['uuid'] === $media['uuid'])->toArray();

        $this->mediaToRemove[] = $media['uuid'];
    }

    public function getMediaCollection($name)
    {
        return $this->mediaCollections[$name];
    }

    public function mount(Product $product)
    {
        $this->product  = $product;
        $this->category = $this->product->category()->pluck('id')->toArray();
        $this->tag      = $this->product->tag()->pluck('id')->toArray();
        $this->initListsForFields();
        $this->mediaCollections = [
            'product_photo' => $product->photo,
        ];
        // $this->tax_ledger_group=Ledger::whereIn('ledger_group_id', ["3"])->pluck('name', 'id')->toArray();


    }

    public function render()
    {
        return view('livewire.product.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->product->save();
        $this->product->category()->sync($this->category);
        $this->product->tag()->sync($this->tag);
        $this->syncMedia();
        // dump($this->product->id);
        // $syncarry = [];
        // foreach ($this->addtax as $attrId => $valueAssoc) {
        //     $syncarry[$valueAssoc["ledger_id"]] = ["rate" => $valueAssoc["rate"]];
        // }
        // $this->product->taxLedgers()->sync($syncarry);



        return redirect()->route('admin.products.index');
    }

    protected function syncMedia(): void
    {
        collect($this->mediaCollections)->flatten(1)
            ->each(fn ($item) => Media::where('uuid', $item['uuid'])
                ->update(['model_id' => $this->product->id]));

        Media::whereIn('uuid', $this->mediaToRemove)->delete();
    }


    protected function rules(): array
    {
        return [
            'product.name' => [
                'string',
                'required',
            ],
            'product.sku' => [
                'string',
                'required',
                'unique:products,sku,' . $this->product->id . ',id,deleted_at,NULL',
            ],
            'product.description' => [
                'string',
                'nullable',
            ],
            'product.price' => [
                'numeric',
                'required',
            ],
            'category' => [
                'array',
            ],
            'category.*.id' => [
                'integer',
                'exists:product_categories,id',
            ],
            'tag' => [
                'array',
            ],
            'tag.*.id' => [
                'integer',
                'exists:product_tags,id',
            ],
            'mediaCollections.product_photo' => [
                'array',
                'nullable',
            ],
            'mediaCollections.product_photo.*.id' => [
                'integer',
                'exists:media,id',
            ],
            // 'tax_ledger_group' => [
            //     'array',
            // ],

            /* 'hsn_code', 'gst_rate', 'cgst_rate', 'sgst_rate', 'igst_rate', 'taxable_price', */

            'product.hsn_code' => [
                'string',
                'required',
            ],
            'product.gst_rate' => [
                'numeric',
                // 'required',
            ],
            'product.cgst_rate' => [
                'numeric',
                // 'required',
            ],
            'product.sgst_rate' => [
                'numeric',
                // 'required',
            ],
            'product.igst_rate' => [
                'numeric',
                // 'required',
            ],
            'product.taxable_price' => [
                'numeric',
                // 'required',
            ],

        ];
    }

    public function updatedProduct($value, $key)
    {
        if (in_array($key, ['sku'])) {
            $this->validateOnly('product.' . $key);
        }
        if (in_array($key, ["gst_rate", "taxable_price", "price"])) {
            $this->calculatePrice();
        }
    }

    public function calculatePrice()
    {
        $gst_rate = floatval($this->product->gst_rate);
        $taxable_price = floatval($this->product->taxable_price);

        // price = taxable_price +(taxable_price * (gst_rate /100))
        $this->product->price = standard_number_format($taxable_price + ($taxable_price * ($gst_rate / 100)));

        $this->product->cgst_rate = standard_number_format($gst_rate / 2);
        $this->product->sgst_rate = standard_number_format($gst_rate / 2);
        $this->product->igst_rate = standard_number_format($gst_rate);
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['category'] = ProductCategory::pluck('name', 'id')->toArray();
        $this->listsForFields['tag']      = ProductTag::pluck('name', 'id')->toArray();
        $this->listsForFields['tax_ledger_group'] = Ledger::whereIn('ledger_group_id', ["1"])->pluck('name', 'id')->toArray();
    }

    public function addtaxClickEvt()
    {

        // $this->addtax[count($this->addtax)+1] = [
        $this->addtax[] = [
            // "ldger_id" => '',
            // "ledger_name" =>'',
            // "amont" => 0
        ];
    }
    public function deletetaxClickEvt($adntxidx)
    {

        // $this->addtax[count($this->addtax)+1] = [
        unset($this->addtax[$adntxidx]);
    }
}
