<?php

namespace App\Http\Livewire\Prints\Admin\Reports;

use App\Models\EmployeeAttendanceLog;
use App\Models\FinYr;
use App\Models\MonthlyPayslip;
use App\Models\SpecialPlannedDay;
use App\Models\Task;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Livewire\Component;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Barryvdh\DomPDF\Facade\Pdf as BarryPDF;

class MonthlyAttendanceExportReport extends Component
{
    public $ddtt;
    public array $holidays = [];
    public array $employeeData = [];
    public array $daysInMonth = [];
    public array $task = [];

    public array $mediaToRemove = [];

    public array $listsForFields = [];

    public array $mediaCollections = [];

    public EmployeeAttendanceLog $employeeAttendanceLog;
    public  $state = [];
    public  $export = "html";

    // querystring
    protected $queryString = [
        'state' => ['except' => '', 'as' => 's'],
        'export' => ['except' => '', 'as' => 'e'],
    ];

    public function addMedia($media): void
    {
        $this->mediaCollections[$media['collection_name']][] = $media;
    }

    public function removeMedia($media): void
    {
        $collection = collect($this->mediaCollections[$media['collection_name']]);

        $this->mediaCollections[$media['collection_name']] = $collection->reject(fn ($item) => $item['uuid'] === $media['uuid'])->toArray();

        $this->mediaToRemove[] = $media['uuid'];
    }

    public function getMediaCollection($name)
    {
        return $this->mediaCollections[$name];
    }

    public function mount()
    {
        // ds('Hi');
        // laradump()->dump('hi');

        // $this->employeeAttendanceLog = $employeeAttendanceLog;
        // $this->task                  = $this->employeeAttendanceLog->task()->pluck('id')->toArray();
        $this->initListsForFields();
        // $this->mediaCollections = [
        //     'employee_attendance_log_sign_in_photo'  => $employeeAttendanceLog->sign_in_photo,
        //     'employee_attendance_log_sign_out_photo' => $employeeAttendanceLog->sign_out_photo,
        // ];


    }

    public function render()
    {
        $this->generateReport();
        // if ($this->export == 'pdf') {
        //     $data=[
        //         'daysInMonth' => $this->daysInMonth,
        //         'employeeData' => $this->employeeData,
        //         'startDate' => $this->startDate,
        //         'employeeData' => $this->employeeData,
        //         // 'this' => $this,
        //         // 'daysInMonth' => $this->daysInMonth,

        //     ];
        //     $pdf = BarryPDF::loadView('prints.monthly-attendance-export-report-v1', $data)->setOptions([
        //         'defaultFont' => 'sans-serif',
        //         'isHtml5ParserEnabled' => true,
        //         "enable_php" => true,
        //     ])
        //         ->setPaper('a4', 'landscape')
        //         //
        //     ;
        //     return $pdf->stream();
        // } else {
        return view('livewire.prints.admin.reports.monthly-attendance-export-report')

            ->layout('layouts.fp-lw-blank');
        // }
    }

    public function submit()
    {
        $this->validate();

        $this->employeeAttendanceLog->save();
        $this->employeeAttendanceLog->task()->sync($this->task);
        $this->syncMedia();

        return redirect()->route('admin.employee-attendance-logs.index');
    }

    protected function syncMedia(): void
    {
        collect($this->mediaCollections)->flatten(1)
            ->each(fn ($item) => Media::where('uuid', $item['uuid'])
                ->update(['model_id' => $this->employeeAttendanceLog->id]));

        Media::whereIn('uuid', $this->mediaToRemove)->delete();
    }

    protected function rules(): array
    {
        return [
            'employeeAttendanceLog.date' => [
                'required',
                'date_format:' . config('project.date_format'),
            ],
            'employeeAttendanceLog.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'employeeAttendanceLog.type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['type'])),
            ],
            'employeeAttendanceLog.coord_lat' => [
                'string',
                'nullable',
            ],
            'employeeAttendanceLog.coord_long' => [
                'string',
                'nullable',
            ],
            'employeeAttendanceLog.coord_accu' => [
                'string',
                'nullable',
            ],
            'employeeAttendanceLog.location' => [
                'string',
                'nullable',
            ],
            'employeeAttendanceLog.signed_in_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
            'employeeAttendanceLog.signed_out_at' => [
                'nullable',
                'date_format:' . config('project.datetime_format'),
            ],
            'mediaCollections.employee_attendance_log_sign_in_photo' => [
                'array',
                'nullable',
            ],
            'mediaCollections.employee_attendance_log_sign_in_photo.*.id' => [
                'integer',
                'exists:media,id',
            ],
            'mediaCollections.employee_attendance_log_sign_out_photo' => [
                'array',
                'nullable',
            ],
            'mediaCollections.employee_attendance_log_sign_out_photo.*.id' => [
                'integer',
                'exists:media,id',
            ],
            'employeeAttendanceLog.device' => [
                'string',
                'nullable',
            ],
            'employeeAttendanceLog.attendance_from' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['attendance_from'])),
            ],
            'task' => [
                'array',
            ],
            'task.*.id' => [
                'integer',
                'exists:tasks,id',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['fin_yr']         = FinYr::pluck('title', 'id')->toArray();
        $this->listsForFields['year']           = $this->getYears();
        $this->listsForFields['month']          = $this->getMonth();
        //
        $this->listsForFields['user']            = User::pluck('name', 'id')->toArray();
        $this->listsForFields['type']            = EmployeeAttendanceLog::TYPE_RADIO;
        $this->listsForFields['attendance_from'] = EmployeeAttendanceLog::ATTENDANCE_FROM_SELECT;
        $this->listsForFields['task']            = Task::pluck('name', 'id')->toArray();
    }

    public function getYears()
    {
        $from = 2022;
        $upto = now()->year;
        $time = now();
        $rangeArr = collect(range($from, $upto))
            // ->reverse()
            ->toArray();

        // return collect($rangeArr)
        //     // ->reverse()
        //     // ->sort()
        //     // ->sortDesc()
        //     ->mapWithKeys(function ($d) {
        //         return [(string)$d => $d];
        //     })->toArray();
        $years = [];
        foreach ($rangeArr as $year) {
            $years[$year] = $time->year($year)->format('Y');
            // $years[] = $year;
        }
        // krsort($years, SORT_NUMERIC);
        return $years;
    }

    public function getMonth($year = null)
    {
        // if current year, get upto current month
        // if previous year, get all months
        // if next year, donot give anything
        $from = 1;
        $upto = 12;
        $currentYear = now()->year;
        $currentMonth = now()->month;

        if ($year == $currentYear) {
            $upto = $currentMonth;
        } elseif ($year < $currentYear) {
            $upto = 12;
        } elseif ($year > $currentYear) {
            $upto = 0;
        }
        $time = now();
        $rangeArr = collect(range($from, $upto))
            // ->reverse()
            ->toArray();

        // return collect($rangeArr)
        //     // ->reverse()
        //     // ->sort()
        //     // ->sortDesc()
        //     ->mapWithKeys(function ($d) {
        //         return [(string)$d => $d];
        //     })->toArray();
        $months = [];
        foreach ($rangeArr as $month) {
            $months[$month] = $time->month($month)->format('F');
            // $years[] = $year;
        }

        return $months;
    }

    function updatedState($value, $key)
    {
        if ($key == 'year') {
            $this->listsForFields['month'] = $this->getMonth($value);

            $this->state['month'] = null;
        }
    }

    // computed property is_searchable
    public function getIsSearchableProperty()
    {
        return (Arr::has($this->state, 'year') && !empty($this->state['year'])) && (Arr::has($this->state, 'month') && !empty($this->state['month']));
    }

    //
    public function getMonthDateProperty()
    {
        $searchable = $this->getIsSearchableProperty();

        if ($searchable) {
            $year = Arr::get($this->state, 'year');
            $month = Arr::get($this->state, 'month');

            // return [$year,$month];
            $mnth = Carbon::createFromFormat('Y-m-d-H-i-s', implode('-', [$year, $month, 1, '00', '00', '00']));
            $mnth = $mnth->startOfDay()
                ->startOfMonth()
                ->startOfHour()
                ->startOfMinute()
                ->startOfSecond();
            // $mnth = Carbon::createFromFormat('Y-m',"$year-$month");

            return $mnth->clone();
        }
    }
    //
    public function getStartDateProperty()
    {
        // return $this->getMonthDateProperty();
        // return ($this->getMonthDateProperty())?->startOfMonth();
        $m = ($this->getMonthDateProperty());
        // ds([
        //     'mnth' => $m->toString(),
        // ]);
        if ($m) {
            $mn =  $m->clone();
            return $mn->startOfMonth()
                // ->addDay()
                ->startOfDay();
        }
    }

    public function getEndDateProperty()
    {
        // return $this->getMonthDateProperty();
        // return $this->getMonthDateProperty()?->endOfMonth();
        $m = ($this->getMonthDateProperty());
        if ($m) {
            $mn =  $m->clone();
            return $mn->endOfMonth();
        }
    }

    public function generateReport()
    {
        // dump('skco');
        $startDate = $this->startDate;
        $endDate = $this->endDate;

        $startDate = $startDate?->startOfDay();
        $endDate = $endDate?->endOfDay();

        $attLogs = EmployeeAttendanceLog::with('user')->whereBetween('date', [$startDate, $endDate])
            ->get();

        // dump($attLogs);
        // dump('skco');
        // laradump()->dump(($attLogs));
        // ds(($attLogs));
        $this->reportCalculate(($attLogs));
        // ds(count($attLogs));
    }

    public function reportCalculate($attLogs)
    {
        $userWise = collect($attLogs)
            ->groupBy('user_id');
        // ds($userWise);

        $daysInMonth = $this->endDate->diffInDays($this->startDate);
        $userArray = [];
        $allUsers = User::attendables()->get();
        $holidays = SpecialPlannedDay::whereBetween('from_date', [$this->startDate, $this->endDate])
            // ->orWhereBetween('to_date', [$this->startDate, $this->endDate])

            ->get();
        $this->holidays = $holidays = $holidays->mapWithKeys(function ($item, $key) {
            return [$item->from_date => $item->leave_type];
        })->toArray();
        foreach ($allUsers as  $user) {
            $daysArray = [];
            $usrData = $userWise->get($user->id);
            if ($usrData) {
                $usrData = $usrData->groupBy('date');
                $usrData = $usrData->map(function ($item, $key) {
                    return $item->first();
                });
                $usrData = $usrData->sortBy('date');
                // $usrData = $usrData->values()->toArray();
            }

            for ($i = 0; $i <= $daysInMonth; $i++) {
                // find if date exists in $usrData
                $date = $this->startDate->clone()->addDays($i)->format('d-m-Y');
                $isHoliday = isset($this->holidays[$date]);
                $status = 'absent';
                if ($usrData && $usrData->has($date)) {
                    $dateData = $usrData->get($date);
                    $status = $dateData?->type;
                }
                if ($isHoliday && !in_array($status, ['present'])) {
                    $status = 'holiday';
                }
                $daysArray[$i + 1] = [
                    // 'Day' => $this->startDate->clone()->addDays($i)->format('d'),
                    // 'Date' => $this->startDate->clone()->addDays($i)->format('Y-m-d'),
                    // 'DayName' => $this->startDate->clone()->addDays($i)->format('l'),
                    'status' => $status,
                    'status_code' => $this->leaveTypeToCodeMap($status),
                ];
            }

            $dayCounts = [];
            $daysArray = collect($daysArray);
            $dayCounts['present'] = count($daysArray->where('status', 'present'));
            $dayCounts['absent'] = count($daysArray->where('status', 'absent'));
            // $dayCounts['half-day'] = count($daysArray->where('status', 'half-day'));
            $dayCounts['late'] = count($daysArray->where('status', 'late'));
            $dayCounts['holiday'] = count($daysArray->where('status', 'holiday'));
            // $dayCounts['paid-leave'] = count($daysArray->where('status', 'paid-leave'));
            // $dayCounts['unpaid-leave'] = count($daysArray->where('status', 'unpaid-leave'));
            $dayCounts['leave'] = count($daysArray->whereIn('status', ['unpaid-leave', 'paid-leave']));


            $userArray[] = [
                // $userArray[$user->id] = [
                // 'user' => $user,
                'name' => $user->name,
                'employee_code' => $user->employee_code,
                'days' => $daysArray,
                'counts' => $dayCounts,
                // 'data' => $usrData,
            ];
        }
        // $days = $this->getDatesBetweenProperty();
        $this->daysInMonth =  $days = $this->getDatesObjectBetweenProperty();

        // ds(json_encode($days))->coffee();
        // ds($holidays);
        // ds($userArray);
        // $this->ddtt = $days;
        $this->ddtt = $userArray;
        $this->employeeData = $userArray;
    }

    // computed property dates_between
    public function getDatesBetweenProperty()
    {
        $dates = [];
        $searchable = $this->getIsSearchableProperty();
        if (!$searchable) {
            return $dates;
        }
        $currentDate = ($this->startDate);
        $endDate = ($this->endDate);
        while ($currentDate->lte($endDate)) {
            $dates[] = $currentDate->format('d-m-Y');
            $currentDate->addDay();
        }
        // ds($dates);
        return $dates;
    }

    // computed property dates_object_between
    public function getDatesObjectBetweenProperty()
    {
        $dates = [];
        $searchable = $this->getIsSearchableProperty();
        if (!$searchable) {
            return $dates;
        }
        $currentDate = ($this->startDate);
        $endDate = ($this->endDate);
        while ($currentDate->lte($endDate)) {
            $df = $currentDate->format('d-m-Y');
            $dates[$df] = [
                'day' => $currentDate->format('j'),
                'day_padded' => $currentDate->format('d'),
                'date' => $currentDate->format('Y-m-d'),
                'day_name' => $currentDate->format('l'),
                'day_code' => $currentDate->format('D'),
                'week' => $currentDate->weekOfMonth,
                'is_holiday' => (isset($this->holidays[$df])) ? true : false,
            ];
            $currentDate->addDay();
        }
        // ds($dates)->danger();
        return $dates;
    }


    public function leaveTypeToCodeMap($type)
    {
        $map = [
            'present'      => 'P',
            'absent'       => 'A',
            'holiday' => 'H',
            'half-day' => 'HD',
            'late' => 'Lt',
            'paid-leave' => 'L',
            'unpaid-leave' => 'L',
        ];
        return $map[$type] ?? '';
    }


    public function getDataForExternal($year, $month)
    {
        $this->state['year'] = $year;
        $this->state['month'] = $month;
        $this->generateReport();
        // ds([
        //     'daysInMonth' => $this->daysInMonth,
        //     'employeeData' => $this->employeeData,
        //     'startDate' => $this->getStartDateProperty(),
        //     'endDate' => $this->getEndDateProperty(),
        //     // 'startDate' => $this->startDate,
        //     // 'endDate' => $this->endDate,
        //     'year' => $year,
        //     'month' => $month,
        // ]);
        return [
            'daysInMonth' => $this->daysInMonth,
            'employeeData' => $this->employeeData,
            'startDate' => $this->getStartDateProperty(),
            'endDate' => $this->getEndDateProperty(),
            // 'startDate' => $this->startDate,
            // 'endDate' => $this->endDate,
        ];
    }
}
