<?php

namespace App\Http\Livewire\MonthlyPayslip;

use App\Http\Livewire\WithConfirmation;
use App\Http\Livewire\WithSorting;
use App\Models\FinYr;
use App\Models\MonthlyPayslip;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;
    use WithSorting;
    use WithConfirmation;

    public array $listsForFields = [];

    public int $perPage;
    public $shouldSearch = false;

    public array $orderable;

    public string $search = '';

    public array $selected = [];

    public array $paginationOptions;

    protected $listeners = [
        'refreshComponent' => '$refresh',
        'payslip-saved' => 'searchUsers',
        'payslip-updated' => 'searchUsers',
        // 'refreshComponent' => '$refresh',
        // 'payslip-saved' => '$refresh',
        // 'payslip-updated' => '$refresh',
    ];

    protected $queryString = [
        'search' => [
            'except' => '',
        ],
        'sortBy' => [
            'except' => 'id',
        ],
        'sortDirection' => [
            'except' => 'desc',
        ],
    ];

    public $filters = [];
    public Collection  $users;

    public function getSelectedCountProperty()
    {
        return count($this->selected);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function resetSelected()
    {
        $this->selected = [];
    }

    public function mount()
    {
        $this->sortBy            = 'id';
        $this->sortDirection     = 'desc';
        $this->perPage           = 100;
        $this->paginationOptions = config('project.pagination.options');
        $this->orderable         = (new MonthlyPayslip())->orderable;

        $this->initListsForFields();
    }

    public function render()
    {
        $query = MonthlyPayslip::with(['finYr', 'user'])->advancedFilter([
            's'               => $this->search ?: null,
            'order_column'    => $this->sortBy,
            'order_direction' => $this->sortDirection,
        ]);

        if ($this->shouldSearch) {
            $monthlyPayslips = $query->paginate($this->perPage);
        } else {
            $query->where('id', 0);
            $monthlyPayslips = $query->paginate($this->perPage);
        }

        return view('livewire.monthly-payslip.index', compact('monthlyPayslips', 'query'));
    }

    public function deleteSelected()
    {
        abort_if(Gate::denies('monthly_payslip_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        MonthlyPayslip::whereIn('id', $this->selected)->delete();

        $this->resetSelected();
    }

    public function delete(MonthlyPayslip $monthlyPayslip)
    {
        abort_if(Gate::denies('monthly_payslip_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $monthlyPayslip->delete();
    }


    protected function initListsForFields(): void
    {
        $this->listsForFields['fin_yr']             = FinYr::pluck('title', 'id')->toArray();
        $this->listsForFields['fin_month']          = [];

        // // $this->listsForFields['year']           = MonthlyPayslip::YEAR_SELECT;
        // // $this->listsForFields['year']           = MonthlyPayslip::getYearsSelect();

        // $this->listsForFields['year']           = MonthlyPayslip::getYearsSelectSequential();

        // // $this->listsForFields['month']          = MonthlyPayslip::MONTH_SELECT;
        // $this->listsForFields['month']          = MonthlyPayslip::getMonthsSelect();
        // // $this->listsForFields['user']           = User::pluck('name', 'id')->toArray();
        // // $this->listsForFields['payment_status'] = $this->monthlyPayslip::PAYMENT_STATUS_SELECT;

        $this->amputateUsers();
    }

    public function amputateUsers()
    {
        $this->users = User::query()
            // ->withExists([
            //     'employeeDetails as has_employee_info',
            //     'paySlips as is_payslip_generated' => function ($query) {
            //         return $query->where($this->filters);
            //     }
            // ])
            //     ->with([
            //         'paySlips' => function ($query) {
            //             $query->where($this->filters);
            //         },
            //     ])
            ->where('id', '<', -1)
            ->get();
    }

    public function searchUsers()
    {
        $this->shouldSearch = true;
        $filterx = collect($this->filters)->except(['fin_month'])->toArray();

        $this->validate([
            'filters.fin_yr_id' => 'required',
            'filters.year' => 'required',
            'filters.month' => 'required',
        ], [], [
            'filters.fin_yr_id' => 'financial year',
            'filters.year' => 'year',
            'filters.month' => 'month',
        ]);
        $this->users = User::withExists([
            'employeeDetails as has_employee_info',
            'paySlips as is_payslip_generated' => function ($query) use ($filterx) {
                return $query->where($filterx);
            }
        ])
            ->with([
                'paySlips' => function ($query) use ($filterx) {
                    $query->where($filterx);
                },
            ])
            ->get();
    }

    //updated fliters
    public function updatedFilters($val, $key)
    {
        // dump("should fire");
        $this->shouldSearch = false;
        $this->amputateUsers();

        if ($key == "fin_yr_id") {
            $this->listsForFields['fin_month'] = FinYr::find($val)?->getFinMonths() ?? ['' => 'Error Loading Months'];
        }
        if ($key == "fin_month") {
            if (!empty($val)) {
                [$month_, $year_] = explode(":", $val);
                $this->filters['month'] = $month_;
                $this->filters['year'] = $year_;
            }
        }
    }
}
