<?php

namespace App\Http\Livewire\MonthlyPayslip;

use App\Models\FinYr;
use App\Models\MonthlyPayslip;
use App\Models\User;
use Livewire\Component;

class CreateOld extends Component
{
    public array $listsForFields = [];

    public MonthlyPayslip $monthlyPayslip;

    public function mount(MonthlyPayslip $monthlyPayslip)
    {
        $this->monthlyPayslip = $monthlyPayslip;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.monthly-payslip.create-old');
    }

    public function submit()
    {
        $this->validate();

        $this->monthlyPayslip->save();

        return redirect()->route('admin.monthly-payslips.index');
    }

    protected function rules(): array
    {
        return [
            'monthlyPayslip.fin_yr_id' => [
                'integer',
                'exists:fin_yrs,id',
                'nullable',
            ],
            'monthlyPayslip.year' => [
                'required',
                'in:' . implode(',', array_keys($this->listsForFields['year'])),
            ],
            'monthlyPayslip.month' => [
                'required',
                'in:' . implode(',', array_keys($this->listsForFields['month'])),
            ],
            'monthlyPayslip.user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'monthlyPayslip.emp_code' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.location' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.name' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.payment_mode' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.bank' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.bank_ac_no' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.aadhaar' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.blood_group' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.days_in_month' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.lwp_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.working_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'monthlyPayslip.esic_no' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.uan' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.basic_salary' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.hra' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.ta' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.incentive' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_earning' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.pf' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.ptax' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.esic' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_deduction' => [
                'numeric',
                'nullable',
            ],
            'monthlyPayslip.total_payment' => [
                'string',
                'nullable',
            ],
            'monthlyPayslip.payment_status' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['payment_status'])),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['fin_yr']         = FinYr::pluck('title', 'id')->toArray();
        $this->listsForFields['year']           = $this->monthlyPayslip::YEAR_SELECT;
        $this->listsForFields['month']          = $this->monthlyPayslip::MONTH_SELECT;
        $this->listsForFields['user']           = User::pluck('name', 'id')->toArray();
        $this->listsForFields['payment_status'] = $this->monthlyPayslip::PAYMENT_STATUS_SELECT;
    }
}
