<?php

namespace App\Http\Livewire\LgAttribute;

use App\Models\LedgerGroup;
use App\Models\LgAttribute;
use Livewire\Component;

class Edit extends Component
{
    public LgAttribute $lgAttribute;

    public array $listsForFields = [];

    public function mount(LgAttribute $lgAttribute)
    {
        $this->lgAttribute = $lgAttribute;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.lg-attribute.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->lgAttribute->save();

        return redirect()->route('admin.lg-attributes.index');
    }

    protected function rules(): array
    {
        return [
            'lgAttribute.title' => [
                'string',
                'required',
            ],
            'lgAttribute.description' => [
                'string',
                'nullable',
            ],
            'lgAttribute.is_active' => [
                'boolean',
            ],
            'lgAttribute.type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['type'])),
            ],
            'lgAttribute.ledger_group_id' => [
                'integer',
                'exists:ledger_groups,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['type']         = $this->lgAttribute::TYPE_RADIO;
        $this->listsForFields['ledger_group'] = LedgerGroup::pluck('name', 'id')->toArray();
    }
}
