<?php

namespace App\Http\Livewire\LedgerGroup;

use App\Http\Livewire\WithConfirmation;
use App\Http\Livewire\WithSorting;
use App\Models\LedgerGroup;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;
    use WithSorting;
    use WithConfirmation;

    public int $perPage;

    public array $orderable;

    public string $search = '';

    public array $selected = [];

    public array $paginationOptions;

    protected $queryString = [
        'search' => [
            'except' => '',
        ],
        'sortBy' => [
            'except' => 'id',
        ],
        'sortDirection' => [
            'except' => 'desc',
        ],
    ];

    public function getSelectedCountProperty()
    {
        return count($this->selected);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function resetSelected()
    {
        $this->selected = [];
    }

    public function mount()
    {
        $this->sortBy            = 'id';
        $this->sortDirection     = 'desc';
        $this->perPage           = 100;
        $this->paginationOptions = config('project.pagination.options');
        $this->orderable         = (new LedgerGroup())->orderable;
    }

    public function render()
    {
        $query = LedgerGroup::advancedFilter([
            's'               => $this->search ?: null,
            'order_column'    => $this->sortBy,
            'order_direction' => $this->sortDirection,
        ]);

        $ledgerGroups = $query->paginate($this->perPage);

        return view('livewire.ledger-group.index', compact('ledgerGroups', 'query'));
    }

    public function deleteSelected()
    {
        abort_if(Gate::denies('ledger_group_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        LedgerGroup::whereIn('id', $this->selected)->delete();

        $this->resetSelected();
    }

    public function delete(LedgerGroup $ledgerGroup)
    {
        abort_if(Gate::denies('ledger_group_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $ledgerGroup->delete();
    }
}
