<?php

namespace App\Http\Livewire\LedgerGroup;

use App\Models\LedgerGroup;
use Livewire\Component;

class Edit extends Component
{
    public LedgerGroup $ledgerGroup;

    public function mount(LedgerGroup $ledgerGroup)
    {
        $this->ledgerGroup = $ledgerGroup;
    }

    public function render()
    {
        return view('livewire.ledger-group.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->ledgerGroup->save();

        return redirect()->route('admin.ledger-groups.index');
    }

    protected function rules(): array
    {
        return [
            'ledgerGroup.name' => [
                'string',
                'nullable',
            ],
            'ledgerGroup.purpose' => [
                'string',
                'nullable',
            ],
        ];
    }
}
