<?php

namespace App\Http\Livewire\Ledger;

use App\Models\Ledger;
use App\Models\LedgerGroup;
use App\Models\LedgerLgAttributeValue;
use App\Models\LgAttribute;
use Illuminate\Support\Arr;
use Livewire\Component;

class Create extends Component
{
    public Ledger $ledger;

    public array $listsForFields = [];
    public $lg_attributes;
    public $lg_attribute_values;
    public $city_id;
    public $ledegr_group_attributes = [];
    public function mount(Ledger $ledger)
    {
        $this->ledger = $ledger;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.ledger.create');
    }

    public function submit()
    {
        $this->validate();

        $this->ledger->save();
        foreach ($this->ledegr_group_attributes as $attrId => $valueAssoc) {
            LedgerLgAttributeValue::create([
                'value_text' => $valueAssoc['value_text'],
                'ledger_id' => $this->ledger->id,
                'lg_attribute_id' => $attrId,
                'lg_attribute_value_id' => Arr::get($valueAssoc, 'value_id', null)
            ]);
        }

        // $this->ledger->ledAttrValues()->create

        return redirect()->route('admin.ledgers.index');
    }

    protected function rules(): array
    {
        return [
            'ledger.name' => [
                'string',
                'nullable',
            ],
            'ledger.description' => [
                'string',
                'nullable',
            ],
            'ledger.ledger_group_id' => [
                'integer',
                'exists:ledger_groups,id',
                'required',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['ledger_group'] = LedgerGroup::pluck('name', 'id')->toArray();
    }
    public function changeEvent($value)
    {
        $this->city_id = $value;
    }


    public function updatedLedger($value, $key)
    {
        // dump($key);
        // $this->city_id = LgAttribute::with(['ledgerGroup']);
        if ($key == "ledger_group_id") {
            $this->reset('ledegr_group_attributes');
            // $this->ledegr_group_attributes=[];
            $this->lg_attributes = LedgerGroup::with(['ledgerattres', 'ledgerattres.ledgerattrvalues'])->find($this->ledger->ledger_group_id);
        }
        // $this->city_id = $this->ledger->ledger_group_id;



        // [$indx, $aKey] = explode('.', $key);

        // foreach ($this->invItems as $key => $ivalue) {
        //     if($ivalue['id']==$indx)
        //     {
        //         // dump($this->invItems[$key]['name']);
        //         $this->invItems[$key]['qnty']=$value;
        //         // $this->invItems['qnty']= intval($value);
        //         $this->invItems[$key]['total'] = floatval(intval($this->invItems[$key]['price']) * intval($value));

        //     }

        // }
        // // if ($aKey == "qnty") {
        // //     // ...
        // //     $price = floatval($this->addeditem[$indx]['price']);
        // //     $qty = intval($value);
        // //     $this->addeditem[$indx]['total'] = $price * $qty;
        // // }
        // $this->evaluteInvtotl();
    }

    public function updatedLedegrGroupAttributes($value, $key)
    {
        [$attrId, $valueTypeKey] = explode(".", $key);
        // dump(compact('value','key','attrId','valueTypeKey'));

        // ledgerattres.ledgerattrvalues
        if ($valueTypeKey == "value_id") {
            $attr = $this->lg_attributes->ledgerattres->find($attrId);
            $attrVal = $attr->ledgerattrvalues->find($value);
            // $this->ledegr_group_attributes[$attrId]["value_text"] = compact('attr', 'attrVal');
            $this->ledegr_group_attributes[$attrId]["value_text"] = $attrVal->value;
        }
    }
}
