<?php

namespace App\Http\Livewire\EmployeeFamilyDetail;

use App\Models\EmployeeFamilyDetail;
use App\Models\EmployeeInfo;
use Livewire\Component;

class Edit extends Component
{
    public array $listsForFields = [];

    public EmployeeFamilyDetail $employeeFamilyDetail;

    public function mount(EmployeeFamilyDetail $employeeFamilyDetail)
    {
        $this->employeeFamilyDetail = $employeeFamilyDetail;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.employee-family-detail.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->employeeFamilyDetail->save();

        return redirect()->route('admin.employee-family-details.index');
    }

    protected function rules(): array
    {
        return [
            'employeeFamilyDetail.employee_info_id' => [
                'integer',
                'exists:employee_infos,id',
                'nullable',
            ],
            'employeeFamilyDetail.relation' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['relation'])),
            ],
            'employeeFamilyDetail.name' => [
                'string',
                'nullable',
            ],
            'employeeFamilyDetail.is_dependent' => [
                'boolean',
            ],
            'employeeFamilyDetail.profession' => [
                'string',
                'nullable',
            ],
            'employeeFamilyDetail.office_name_address' => [
                'string',
                'nullable',
            ],
            'employeeFamilyDetail.office_contact' => [
                'string',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['employee_info'] = EmployeeInfo::pluck('first_name', 'id')->toArray();
        $this->listsForFields['relation']      = $this->employeeFamilyDetail::RELATION_RADIO;
    }
}
