<?php

namespace App\Http\Livewire\EmployeeEducationalInfo;

use App\Models\EmployeeEducationalInfo;
use App\Models\EmployeeInfo;
use Livewire\Component;

class Create extends Component
{
    public array $listsForFields = [];

    public EmployeeEducationalInfo $employeeEducationalInfo;

    public function mount(EmployeeEducationalInfo $employeeEducationalInfo)
    {
        $this->employeeEducationalInfo = $employeeEducationalInfo;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.employee-educational-info.create');
    }

    public function submit()
    {
        $this->validate();

        $this->employeeEducationalInfo->save();

        return redirect()->route('admin.employee-educational-infos.index');
    }

    protected function rules(): array
    {
        return [
            'employeeEducationalInfo.employee_info_id' => [
                'integer',
                'exists:employee_infos,id',
                'nullable',
            ],
            'employeeEducationalInfo.degree_name' => [
                'string',
                'nullable',
            ],
            'employeeEducationalInfo.year' => [
                'string',
                'nullable',
            ],
            'employeeEducationalInfo.board_name' => [
                'string',
                'nullable',
            ],
            'employeeEducationalInfo.subjects' => [
                'string',
                'max:500',
                'nullable',
            ],
            'employeeEducationalInfo.grade' => [
                'string',
                'nullable',
            ],
            'employeeEducationalInfo.course_type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['course_type'])),
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['employee_info'] = EmployeeInfo::pluck('first_name', 'id')->toArray();
        $this->listsForFields['course_type']   = $this->employeeEducationalInfo::COURSE_TYPE_RADIO;
    }
}
