<?php

namespace App\Http\Livewire\Company;

use App\Models\Company;
use Livewire\Component;

class Edit extends Component
{
    public Company $company;

    public function mount(Company $company)
    {
        $this->company = $company;
    }

    public function render()
    {
        return view('livewire.company.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->company->save();

        return redirect()->route('admin.companies.index');
    }

    protected function rules(): array
    {
        return [
            'company.name' => [
                'string',
                'max:50',
                'nullable',
            ],
            'company.mailing_name' => [
                'string',
                'max:30',
                'nullable',
            ],
            'company.address_line_one' => [
                'string',
                'max:50',
                'nullable',
            ],
            'company.address_line_two' => [
                'string',
                'nullable',
            ],
            'company.state' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.city' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.pin' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.phone' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.email' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.mobile' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.fax_no' => [
                'string',
                'max:20',
                'nullable',
            ],
            'company.website' => [
                'string',
                'max:30',
                'nullable',
            ],
            'company.gst_state' => [
                'string',
                'max:15',
                'nullable',
            ],
            'company.registration_type' => [
                'string',
                'max:15',
                'nullable',
            ],
            'company.gstin' => [
                'string',
                'max:30',
                'nullable',
            ],
            'company.period_gstr_one' => [
                'string',
                'nullable',
            ],
            'company.eway_bill_is_applicable' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'company.threshold_limit' => [
                'numeric',
                'nullable',
            ],
            'company.apply_for_inter_state' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'company.inter_threshold_limit' => [
                'numeric',
                'nullable',
            ],
        ];
    }
}
