<?php

namespace App\Http\Livewire\Common;

use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Service;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class ServiceSearchModalComponent extends ModalComponent
{
    public array $listsForFields = [];
    public $categoryIds = [];
    public $productIds = [];

    public $search = '';

    public function mount()
    {
        $this->initListsForFields();
    }

    public function render()
    {
        $pordQ = Service::query();
        if ($this->search) {
            $pordQ->where(function ($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                    ->orWhere('description', 'like', '%' . $this->search . '%');
            });
        }
        // if ($this->categoryIds) {
        //     $pordQ->whereHas('category', function ($q) {
        //         $q->whereIn('id', $this->categoryIds);
        //     });
        // }
        // // data[products]
        $data = [];
        if ($this->search) {
            $data['products'] = $pordQ->get();
        } else {
            $data['products'] = $pordQ->where('id', '-9')->get();
        }
        return view('livewire.common.service-search-modal-component', $data);
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['categories'] = ProductCategory::pluck('name', 'id')->toArray();
    }
    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return 'lg';
    }
    public static function closeModalOnEscape(): bool
    {
        return false;
    }

    public function addProducts()
    {
        $this->emit('servicesSelected', $this->productIds);
        $this->closeModal();
    }

}
