<?php

namespace App\Http\Livewire\ClientGroup;

use App\Models\Circle;
use App\Models\ClientGroup;
use App\Models\Role;
use App\Models\State;
use App\Models\Zone;
use Livewire\Component;

class Edit extends Component
{
    public array $zone = [];

    public array $state = [];

    public array $circle = [];

    public ClientGroup $clientGroup;

    public array $listsForFields = [];

    public function mount(ClientGroup $clientGroup)
    {
        $this->clientGroup = $clientGroup;
        $this->zone        = $this->clientGroup->zone()->pluck('id')->toArray();
        $this->state       = $this->clientGroup->state()->pluck('id')->toArray();
        $this->circle      = $this->clientGroup->circle()->pluck('id')->toArray();
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.client-group.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->clientGroup->save();
        $this->clientGroup->zone()->sync($this->zone);
        $this->clientGroup->state()->sync($this->state);
        $this->clientGroup->circle()->sync($this->circle);

        return redirect()->route('admin.client-groups.index');
    }

    protected function rules(): array
    {
        return [
            'clientGroup.name' => [
                'string',
                'nullable',
            ],
            'clientGroup.business_name' => [
                'string',
                'nullable',
            ],
            'clientGroup.address' => [
                'string',
                'nullable',
            ],
            'clientGroup.phone_1' => [
                'string',
                'nullable',
            ],
            'clientGroup.phone_2' => [
                'string',
                'nullable',
            ],
            'clientGroup.email_1' => [
                'string',
                'nullable',
            ],
            'clientGroup.email_2' => [
                'string',
                'nullable',
            ],
            'clientGroup.is_active' => [
                'boolean',
            ],
            'clientGroup.has_multi_state_business' => [
                'boolean',
            ],
            'zone' => [
                'array',
            ],
            'zone.*.id' => [
                'integer',
                'exists:zones,id',
            ],
            'state' => [
                'array',
            ],
            'state.*.id' => [
                'integer',
                'exists:states,id',
            ],
            'circle' => [
                'array',
            ],
            'circle.*.id' => [
                'integer',
                'exists:circles,id',
            ],
            'clientGroup.operation_manager_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['zone']   = Zone::pluck('name', 'id')->toArray();
        $this->listsForFields['state']  = State::pluck('name', 'id')->toArray();
        $this->listsForFields['circle'] = Circle::pluck('name', 'id')->toArray();
        $clientOms = Role::where('id', Role::ROLE_CLIENT_OM_ID)->first();
        $this->listsForFields['operation_manager']  = $clientOms->users()->pluck('name', 'id')->toArray();
    }
}
