<?php

namespace App\Http\Livewire\ClientBranch;

use App\Models\Circle;
use App\Models\Client;
use App\Models\ClientBranch;
use App\Models\Region;
use Livewire\Component;

class Edit extends Component
{
    public array $listsForFields = [];

    public ClientBranch $clientBranch;

    public function mount(ClientBranch $clientBranch)
    {
        $this->clientBranch = $clientBranch;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.client-branch.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->clientBranch->save();

        return redirect()->route('admin.client-branches.index');
    }

    protected function rules(): array
    {
        return [
            'clientBranch.solid_code' => [
                // 'string',
                'required',
                'unique:client_branches,solid_code,' . $this->clientBranch->id . ',id,deleted_at,NULL',
            ],
            'clientBranch.name' => [
                'string',
                'nullable',
            ],
            'clientBranch.address' => [
                'string',
                'nullable',
            ],
            'clientBranch.email' => [
                'string',
                'nullable',
            ],
            'clientBranch.phone' => [
                'string',
                'nullable',
            ],
            'clientBranch.phone_2' => [
                'string',
                'nullable',
            ],
            'clientBranch.circle_id' => [
                'integer',
                'exists:circles,id',
                'nullable',
            ],
            // 'clientBranch.region_id' => [
            //     'integer',
            //     'exists:regions,id',
            //     'nullable',
            // ],
            'clientBranch.full_name' => [
                'string',
                'nullable',
            ],
            'clientBranch.latitude' => [
                'string',
                'nullable',
            ],
            'clientBranch.longitude' => [
                'string',
                'nullable',
            ],
            'clientBranch.client_id' => [
                'integer',
                'exists:clients,id',
                'nullable',
            ],
        ];
    }

    public function validationAttributes(): array
    {
        return [
            'clientBranch.solid_code' => 'SOL Id',
        ];
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['region'] = Region::pluck('name', 'id')->toArray();
        $this->listsForFields['circle'] = Circle::pluck('name', 'id')->toArray();
        $this->listsForFields['client'] = Client::pluck('name', 'id')->toArray();
    }

    public function updatedClientBranch($val, $key)
    {
        // dump($key);
        if (in_array($key, ['solid_code'])) {
            $this->validateOnly('clientBranch.' . $key);
        }
    }
}
