<?php

namespace App\Http\Livewire\Client;

use App\Models\Client;
use App\Models\ClientGroup;
use App\Models\State;
use Livewire\Component;

class Create extends Component
{
    public Client $client;

    public array $listsForFields = [];

    public function mount(Client $client)
    {
        $this->client            = $client;
        $this->client->is_active = true;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.client.create');
    }

    public function submit()
    {
        $this->validate();

        $this->client->save();

        return redirect()->route('admin.clients.index');
    }

    protected function rules(): array
    {
        return [
            'client.client_group_id' => [
                'integer',
                'exists:client_groups,id',
                'nullable',
            ],
            'client.state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],
            'client.name' => [
                'string',
                'nullable',
            ],
            'client.rhq_address' => [
                'string',
                'nullable',
            ],
            'client.rhq_phone' => [
                'string',
                'nullable',
            ],
            'client.rhq_email' => [
                'string',
                'nullable',
            ],
            'client.gstin' => [
                'string',
                'nullable',
            ],
            'client.gst_reg_type' => [
                'nullable',
                'in:' . implode(',', array_keys($this->listsForFields['gst_reg_type'])),
            ],
            'client.is_active' => [
                'boolean',
            ],
        ];
    }

    protected function initListsForFields(): void
    {
        $this->listsForFields['client_group'] = ClientGroup::pluck('business_name', 'id')->toArray();
        $this->listsForFields['state']        = State::pluck('name', 'id')->toArray();
        $this->listsForFields['gst_reg_type'] = $this->client::GST_REG_TYPE_SELECT;
    }
}
