<?php

namespace App\Http\Livewire\CircleOfficer\Circle\Product;

use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductCircleHistory;
use App\Models\ProductCirclePivot;
use App\Models\User;
use App\Models\Circle;
use Livewire\Component;

class CircleWiseProductListComponent extends Component
{
    public array $listsForFields = [];

    // public Circle|null $selectedCircle;
    // public  $circle_id;
    public Circle $circle;
    public $filters = [
        'categories' => [],
    ];
    public $state = [
        'stock' => [],
    ];
    protected $queryString = [
        // 'circle_id' => [
        //     'except' => null,
        //     'as' => 'circle',
        // ]
    ];



    public function mount(Circle $circle)
    {

        // $this->productCirclePivot->quantity = '0';
        $this->initListsForFields();
    }

    public function render()
    {
        $data = [];
        // $circle = Circle::find($this->circle->id);
        $circle = $this->circle;

        if ($circle) {
            // $this->state['productCirclePivots'] = ProductCirclePivot::where('circle_id', $this->circle->id)->get();
            // $prodQuery = Product::query();
            $prodQuery = $circle->products();
            // select  products that matches filters->categories
            if (!empty($this->filters['categories'])) {
                $prodQuery->whereHas('category', function ($query) {
                    $query->whereIn('id', $this->filters['categories']);
                });
            }


            //
            $data['products'] = $prodQuery->with([
                'circles' => function ($query) {
                    $query->where('circle_id', $this->circle->id)
                        // ->select('id', 'name', 'stock')
                    ;
                },
                // 'productCirclePivots' => function ($query) {
                //     $query->where('circle_id', $this->circle->id);
                // }
            ])->get()
                ->map(function ($product) {
                    // $circle = ($product->circles->first());
                    // $product->stock = $circle ? $circle->pivot->quantity : 0;
                    // return $product;


                    // $zone = ($product->zones->first());
                    $circle = ($product->circles->first());
                    // $product->zoneStock = $zone ? $zone->pivot->quantity : 0;
                    // $this->state['max'][$product->id] = $product->zoneStock;
                    $product->stock = $circle ? $circle->pivot->quantity : 0;
                    return $product;
                });
        } else {

            $data['products'] = Product::where('id', '-9')->get();
            // reset circle_id
            $this->reset('circle_id');
        }
        $data['circle'] = $circle;

        return view('livewire.circle-officer.circle.product.circle-wise-product-list-component', $data);
    }

    public function submit()
    {
        // $this->validate();
        // $this->productCirclePivot->save();

        // return redirect()->route('admin.product-circle-pivots.index');
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['product']         = Product::pluck('name', 'id')->toArray();
        $this->listsForFields['circle']            = Circle::pluck('name', 'id')->toArray();
        $this->listsForFields['categories']      = ProductCategory::pluck('name', 'id')->toArray();
        $this->listsForFields['last_updated_by'] = User::pluck('name', 'id')->toArray();
    }

    public function updatedCircleId($val, $key)
    {
        // dump(compact('val', 'key'));
        $this->state['stock'] = [];
        $this->resetErrorBag();
    }

    public function loadProducts()
    {
    }

    public function addStocks()
    {
        $user = auth()->user();
        $this->validate([
            'state.stock.*.add' => 'required|integer|min:1',
        ], [
            'state.stock.*.add.required' => 'Please enter stock',
            'state.stock.*.add.integer' => 'Please enter valid stock',
            'state.stock.*.add.min' => 'Please enter valid stock',
        ]);
        $productIds = array_keys($this->state['stock']);
        $productCirclePivots = ProductCirclePivot::whereIn('product_id', $productIds)
            ->where('circle_id', $this->circle->id)->get();

        foreach ($this->state['stock'] as $key => $stock) {
            $productCirclePivot = $productCirclePivots->where('product_id', $key)
                ->where('circle_id', $this->circle->id)
                ->first();
            $quantity_before = 0;
            $stockToAdd = $stock['add'];
            if ($productCirclePivot) {
                $quantity_before = $productCirclePivot->quantity;
                $productCirclePivot->quantity += $stock['add'];
                $productCirclePivot->save();
            } else {
                ProductCirclePivot::create([
                    'product_id' => $key,
                    'circle_id' => $this->circle->id,
                    'quantity' => $stock['add'],
                ]);
            }
            // ProductCircleHistory
            ProductCircleHistory::create([
                'product_id' => $key,
                'circle_id' => $this->circle->id,
                'quantity' => $stockToAdd,
                'quantity_before' => $quantity_before,
                'action' => 'add',
                'updated_by_id' => auth()->id(),
            ]);
        }
        $this->state['stock'] = [];

        // dispatch success alert
        $this->dispatchBrowserEvent('alert', [
            'type' => 'success',
            'message' => 'Stock added successfully',
        ]);
    }
    // protected function rules(): array
    // {
    //     return [
    //         'productCirclePivot.product_id' => [
    //             'integer',
    //             'exists:products,id',
    //             'nullable',
    //         ],
    //         'productCirclePivot.circle_id' => [
    //             'integer',
    //             'exists:circles,id',
    //             'nullable',
    //         ],
    //         'productCirclePivot.quantity' => [
    //             'integer',
    //             'min:-2147483648',
    //             'max:2147483647',
    //             'nullable',
    //         ],
    //         'productCirclePivot.price' => [
    //             'numeric',
    //             'nullable',
    //         ],
    //         'productCirclePivot.last_updated_by_id' => [
    //             'integer',
    //             'exists:users,id',
    //             'nullable',
    //         ],
    //     ];
    // }
}
