<?php

namespace App\Http\Livewire\CircleOfficer\Circle;

use App\Http\Livewire\WithConfirmation;
use App\Http\Livewire\WithSorting;
use App\Models\Task;
use App\Models\User;
use App\Models\Zone;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;
use Livewire\Component;
use Livewire\WithPagination;

class MyCircles extends Component
{
    use WithPagination;
    use WithSorting;
    use WithConfirmation;

    public int $perPage;
    private User $user;

    public array $orderable;

    public string $search = '';

    public array $selected = [];

    public array $paginationOptions;

    protected $queryString = [
        'search' => [
            'except' => '',
        ],
        'sortBy' => [
            'except' => 'id',
        ],
        'sortDirection' => [
            'except' => 'desc',
        ],
    ];

    public function getSelectedCountProperty()
    {
        return count($this->selected);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function resetSelected()
    {
        $this->selected = [];
    }

    public function mount()
    {
        $this->sortBy            = 'id';
        $this->sortDirection     = 'desc';
        $this->perPage           = 100;
        $this->paginationOptions = config('project.pagination.options');
        $this->orderable         = (new Zone())->orderable;

        $this->user = User::getAuthUser();
    }

    public function render()
    {
        // $query = Zone::query();
        $query = $this->user->circles();

        $query->with([
            'client_branches',
            'circleOfficer',
        ])->advancedFilter([
            's'               => $this->search ?: null,
            'order_column'    => $this->sortBy,
            'order_direction' => $this->sortDirection,
        ]);

        $circles = $query->paginate($this->perPage);
        $circles2 = $query->get();
        $circlesJson = $circles2->map(function ($circle) {
                    return [
                        'title' => $circle->name,
                        'children' => $circle->client_branches->map(function ($branch) {
                            return [
                                'title' => $branch->name,
                            ];
                        }),
                    ];
        });


        return view('livewire.circle-officer.circle.my-circles', compact('query', 'circles', 'circlesJson','circles2'));
    }

    public function deleteSelected()
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        Task::whereIn('id', $this->selected)->delete();

        $this->resetSelected();
    }

    public function delete(Task $task)
    {
        abort_if(Gate::denies('task_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $task->delete();
    }
}
