<?php

namespace App\Http\Livewire\Circle;

use App\Models\Circle;
use App\Models\State;
use App\Models\User;
use App\Models\Zone;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Edit extends Component
{
    public Circle $circle;
    public array $engineer = [];

    public array $listsForFields = [];

    public function mount(Circle $circle)
    {
        $this->circle = $circle;
        $this->engineer = $this->circle->engineer()->pluck('id')->toArray();
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.circle.edit');
    }

    public function submit()
    {
        $this->validate();

        $this->circle->save();
        $this->circle->engineer()->sync($this->engineer);

        return redirect()->route('admin.circles.index');
    }

    protected function rules(): array
    {
        return [
            'circle.name' => [
                'string',
                'nullable',
            ],
            'circle.is_active' => [
                'boolean',
            ],
            'circle.state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],
            'circle.zone_id' => [
                'integer',
                'exists:zones,id',
                'nullable',
            ],
            'circle.circle_officer_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'engineer' => [
                'array',
            ],
            'engineer.*.id' => [
                'integer',
                'exists:users,id',
            ],
        ];
    }

    protected function initListsForFields(): void
    {

        $this->listsForFields['zones'] = Zone::pluck('name', 'id')->toArray();
        // $this->listsForFields['state'] = State::pluck('name', 'id')->toArray();
        $this->listsForFields['circle_officer'] = User::whereHas('roles', function ($query) {
            $query->where('role_id', 3);
        })->get()->pluck('name_role', 'id')->toArray();

        $userIds =  DB::table('role_user')->select('user_id')
            ->whereIn('role_id', [4, 5])->get()->pluck('user_id')->toArray();
        $engineers = User::with('roles')->whereIn('id', $userIds)->get();
        $engineersArr = $engineers->mapWithKeys(function ($u) {
            return [$u->id => $u->name . "  (" . $u->roles[0]->title . ")"];
        })->toArray();
        $this->listsForFields['engineer'] = $engineersArr;
    }
}
