<?php

namespace App\Http\Livewire\Circle;

use App\Models\Circle;
use App\Models\State;
use App\Models\Zone;
use Livewire\Component;

class Create extends Component
{
    public Circle $circle;

    public array $listsForFields = [];

    public function mount(Circle $circle)
    {
        $this->circle            = $circle;
        $this->circle->is_active = true;
        $this->initListsForFields();
    }

    public function render()
    {
        return view('livewire.circle.create');
    }

    public function submit()
    {
        $this->validate();

        $this->circle->save();

        return redirect()->route('admin.circles.index');
    }

    protected function rules(): array
    {
        return [
            'circle.name' => [
                'string',
                'nullable',
            ],
            'circle.is_active' => [
                'boolean',
            ],
            'circle.zone_id' => [
                'integer',
                'exists:zones,id',
                'nullable',
            ],
            // 'circle.state_id' => [
            //     'integer',
            //     'exists:states,id',
            //     'nullable',
            // ],
        ];
    }

    protected function initListsForFields(): void
    {
        // $this->listsForFields['state'] = State::pluck('name', 'id')->toArray();
        $this->listsForFields['zones'] = Zone::pluck('name', 'id')->toArray();
    }
}
