<?php

namespace App\Http\Livewire\Admin\VisitReimbursement\Reports;

use App\Models\User;
use App\Models\VisitReimbursement;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Livewire\Component;

class EmployeeWiseTaReport extends Component
{
    public array $state = [
        'engineer' => null,
        'year_month' => null,
        'date' => null,
    ];
    private $year_month_format = 'F, Y';
    public array $listsForFields = [
        'engineers' => [],
        'ranges' => [],
    ];

    // validation field names
    protected $validationAttributes = [
        'state.engineer' => 'engineer',
        'state.year_month' => 'month',
        'state.range' => 'range',
    ];


    protected $queryString = [
        'state' => ['except' => '', 'as' => 's'],
        // 'export' => ['except' => '', 'as' => 'e'],
    ];

    public Collection|null|array $visitReimbursements;
    public User|null $employee = null;
    public $period = null;


    public function render()
    {
        return view('livewire.admin.visit-reimbursement.reports.employee-wise-ta-report');
    }

    public function mount()
    {
        $this->initListsForFields();
    }

    public function initListsForFields()
    {
        $this->listsForFields['engineers'] = \App\Models\User::engineersAndCircleOfficers()->pluck('name', 'id')->toArray();
    }

    // updatedStateYearMonth
    public function updatedStateYearMonth($value)
    {
        if ($value) {
            $this->state['date'] = $dt = \Carbon\Carbon::createFromFormat('d, ' . $this->year_month_format, '01, ' . $value);
            $this->listsForFields['ranges'] = getDateRangesForMonth($dt->year, $dt->month);
        } else {
            $this->state['date'] = null;
            $this->listsForFields['ranges'] = [];
        }
    }

    // computed attribute date_range_options
    public function getDateRangeOptionsProperty()
    {
        return Arr::mapWithKeys($this->listsForFields['ranges'], function ($value, $key) {
            // return [$value['from_dt']?->format('d-m-Y') . '||' . $value['to_dt']?->format('d-m-Y') => $value['from_dt']?->format('d') . ' - ' . $value['to_dt']?->format('d')];
            return [$value['key']  => $value['label']];
        });
    }


    public function generateReport($skipValidation = false)
    {
        if (!$skipValidation)
            $this->validate([
                'state.engineer' => 'required|exists:users,id',
                'state.year_month' => 'required',
                'state.range' => 'required',
            ]);

        $range = explode('||', $this->state['range']);
        $from_dt = \Carbon\Carbon::createFromFormat('Y-m-d', $range[0]);
        $to_dt = \Carbon\Carbon::createFromFormat('Y-m-d', $range[1]);

        $this->employee = User::find($this->state['engineer']);
        $this->period = $from_dt->format('d') . ' - ' . $to_dt->format('d') . ' ' . $from_dt->format('F, Y');

        // VisitReimbursement.visit.date between $from_dt and $to_dt
        $this->visitReimbursements = $records = VisitReimbursement::with(['visit', 'routes'])
            ->where('user_id', $this->state['engineer'])
            ->whereHas('visit', function ($query) use ($from_dt, $to_dt) {
                $query->whereBetween('date', [$from_dt, $to_dt]);
            })
            ->get();

        // /
        // dump($records->toArray());
    }


    public function getDataForExternal($user_id, $year_month, $range)
    {
        // $this->state['engineer'] = $user_id;
        // $this->state['year_month'] = $year_month;
        // $this->updatedStateYearMonth($year_month);
        // $this->state['range'] = $range;

        // // use fill method
        // $this->fill([
        //     'state.engineer' => $user_id,
        //     'state.year_month' => $year_month,
        //     'state.range' => $range,
        // ]);
        // $args = [
        //     'state.engineer' => $user_id,
        //     'state.year_month' => $year_month,
        //     'state.range' => $range,
        // ];
        // dd($this->state, $args);
        $this->generateReport( /* $skipValidation = */true);
        return [
            'employee' => $this->employee,
            'period' => $this->period,
            'visitReimbursements' => $this->visitReimbursements,
        ];
    }
}
