<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }




    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response|\Illuminate\Http\JsonResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function login_custom(Request $request)
    {
        // dd($request->input());
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if (
            method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)
        ) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        // if ($this->attemptLogin($request)) {
        //     if ($request->hasSession()) {
        //         $request->session()->put('auth.password_confirmed_at', time());
        //     }

        //     return $this->sendLoginResponse($request);
        // }

        $user = User::where(function ($q) use ($request) {
            $username = $request->input($this->username());
            $q->where('username', $username)
                ->orWhere('email', $username)
                ->orWhere('employee_code', $username)
                ->orWhere('phone', $username);
        })->first();

        if ($user) {
            $password = $request->password;
            if (Hash::check($password, $user->password)) {
                // Auth::guard()->login($user, $request->remember == "on");
                Auth::guard()->loginUsingId($user->id, $request->remember == "on");
                // return "ok";

                // dd(auth());
                // dd(auth()->user());
                if ($request->hasSession()) {
                    $request->session()->put('auth.password_confirmed_at', time());
                }
                // dd($this->redirectPath());
                return $this->sendLoginResponse($request);
            }
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    public function redirectTo()
    {
        // $user = auth()->user();
        $user = User::getAuthUser();
        // dd($user);
        if ($user->isAdmin()) {
            return url("/admin");
        }
        if ($user->isZonalOfficer()) {
            return url("/zonal-officer");
        }

        if ($user->isUser()) {
            return url("/admin");
        }

        if ($user->isCircleOfficer()) {
            return url("/circle-officer");
        }

        if ($user->isHeadEngineer()) {
            return url("/engineer");
        }

        if ($user->isEngineer()) {
            return url("/engineer");
        }

        if ($user->isClientOM()) {
            return url("/client");
        }
    }


    public function spookyLogin(Request $request)
    {
        $id = $request->get('id');
        abort_if(is_null($id), 419, "Not a valid id");
        // $user = User::findOrFail($id);
        Auth::guard()->loginUsingId($id, true);

        return response()->redirectTo($this->redirectTo());
    }

    public function spookyLoginGet(Request $request)
    {

        $users = User::with('roles')->get();
        $usersByRole = [];

        foreach ($users as $user) {
            foreach ($user->roles as $role) {
                $usersByRole[$role->title][] = $user;
            }
        }


        $users = $usersByRole;
        // return $users;
        return view('auth.spooky-logins', compact('users'));
    }
}
