<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreSpecialPlannedDayRequest;
use App\Http\Requests\UpdateSpecialPlannedDayRequest;
use App\Http\Resources\Admin\SpecialPlannedDayResource;
use App\Models\SpecialPlannedDay;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SpecialPlannedDayApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('special_planned_day_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new SpecialPlannedDayResource(SpecialPlannedDay::all());
    }

    public function store(StoreSpecialPlannedDayRequest $request)
    {
        $specialPlannedDay = SpecialPlannedDay::create($request->validated());

        return (new SpecialPlannedDayResource($specialPlannedDay))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(SpecialPlannedDay $specialPlannedDay)
    {
        abort_if(Gate::denies('special_planned_day_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new SpecialPlannedDayResource($specialPlannedDay);
    }

    public function update(UpdateSpecialPlannedDayRequest $request, SpecialPlannedDay $specialPlannedDay)
    {
        $specialPlannedDay->update($request->validated());

        return (new SpecialPlannedDayResource($specialPlannedDay))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(SpecialPlannedDay $specialPlannedDay)
    {
        abort_if(Gate::denies('special_planned_day_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $specialPlannedDay->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
