<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreProductTaskEventLogRequest;
use App\Http\Requests\UpdateProductTaskEventLogRequest;
use App\Http\Resources\Admin\ProductTaskEventLogResource;
use App\Models\ProductTaskEventLog;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ProductTaskEventLogApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('product_task_event_log_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ProductTaskEventLogResource(ProductTaskEventLog::with(['taskEventLog', 'product', 'approvedBy'])->get());
    }

    public function store(StoreProductTaskEventLogRequest $request)
    {
        $productTaskEventLog = ProductTaskEventLog::create($request->validated());

        return (new ProductTaskEventLogResource($productTaskEventLog))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(ProductTaskEventLog $productTaskEventLog)
    {
        abort_if(Gate::denies('product_task_event_log_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ProductTaskEventLogResource($productTaskEventLog->load(['taskEventLog', 'product', 'approvedBy']));
    }

    public function update(UpdateProductTaskEventLogRequest $request, ProductTaskEventLog $productTaskEventLog)
    {
        $productTaskEventLog->update($request->validated());

        return (new ProductTaskEventLogResource($productTaskEventLog))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(ProductTaskEventLog $productTaskEventLog)
    {
        abort_if(Gate::denies('product_task_event_log_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $productTaskEventLog->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
