<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreEmployeeEducationalInfoRequest;
use App\Http\Requests\UpdateEmployeeEducationalInfoRequest;
use App\Http\Resources\Admin\EmployeeEducationalInfoResource;
use App\Models\EmployeeEducationalInfo;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeEducationalInfoApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_educational_info_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeEducationalInfoResource(EmployeeEducationalInfo::with(['employeeInfo'])->get());
    }

    public function store(StoreEmployeeEducationalInfoRequest $request)
    {
        $employeeEducationalInfo = EmployeeEducationalInfo::create($request->validated());

        return (new EmployeeEducationalInfoResource($employeeEducationalInfo))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(EmployeeEducationalInfo $employeeEducationalInfo)
    {
        abort_if(Gate::denies('employee_educational_info_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new EmployeeEducationalInfoResource($employeeEducationalInfo->load(['employeeInfo']));
    }

    public function update(UpdateEmployeeEducationalInfoRequest $request, EmployeeEducationalInfo $employeeEducationalInfo)
    {
        $employeeEducationalInfo->update($request->validated());

        return (new EmployeeEducationalInfoResource($employeeEducationalInfo))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(EmployeeEducationalInfo $employeeEducationalInfo)
    {
        abort_if(Gate::denies('employee_educational_info_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeEducationalInfo->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
