<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreClientBranchRequest;
use App\Http\Requests\UpdateClientBranchRequest;
use App\Http\Resources\Admin\ClientBranchResource;
use App\Models\ClientBranch;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClientBranchApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('client_branch_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ClientBranchResource(ClientBranch::with(['region'])->get());
    }

    public function store(StoreClientBranchRequest $request)
    {
        $clientBranch = ClientBranch::create($request->validated());

        return (new ClientBranchResource($clientBranch))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(ClientBranch $clientBranch)
    {
        abort_if(Gate::denies('client_branch_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ClientBranchResource($clientBranch->load(['region']));
    }

    public function update(UpdateClientBranchRequest $request, ClientBranch $clientBranch)
    {
        $clientBranch->update($request->validated());

        return (new ClientBranchResource($clientBranch))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(ClientBranch $clientBranch)
    {
        abort_if(Gate::denies('client_branch_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $clientBranch->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
