<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCircleRequest;
use App\Http\Requests\UpdateCircleRequest;
use App\Http\Resources\Admin\CircleResource;
use App\Models\Circle;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CircleApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('circle_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new CircleResource(Circle::with(['state'])->get());
    }

    public function store(StoreCircleRequest $request)
    {
        $circle = Circle::create($request->validated());

        return (new CircleResource($circle))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Circle $circle)
    {
        abort_if(Gate::denies('circle_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new CircleResource($circle->load(['state']));
    }

    public function update(UpdateCircleRequest $request, Circle $circle)
    {
        $circle->update($request->validated());

        return (new CircleResource($circle))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Circle $circle)
    {
        abort_if(Gate::denies('circle_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $circle->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
