<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmployeeInfo;
use App\Models\User;
use Carbon\Carbon;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('user_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.user.index');
    }

    public function create()
    {
        abort_if(Gate::denies('user_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.user.create');
    }

    public function edit(User $user)
    {
        abort_if(Gate::denies('user_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.user.edit', compact('user'));
    }

    public function show(User $user)
    {
        abort_if(Gate::denies('user_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $user->load('roles');

        return view('admin.user.show', compact('user'));
    }
    public function employeeDetails(User $user)
    {
        // abort_if(Gate::denies('user_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $user->load([
            'roles',
            'employeeDetails.educationalDetails',
            'employeeDetails.familyDetails',
        ]);
        // return $user;
        return view('admin.user.employee-details', compact('user'));
    }

    public function UploadBulkUserWithDetails(Request $request)
    {
        $password = Hash::make("nopass");
        foreach ($this->userArray01 as $key => $value) {
            $employeeCode = $value['Employee Code'];
            // check if same employee code exists and not null

            $user = User::where('employee_code', $employeeCode)->first();
            if (!$user) {
                $user = User::create([
                    'name' => $value['Name'],
                    'employee_code' => $value['Employee Code'],
                    'phone' => Arr::get(explode("/", $value['Mobile No.']), '0'),
                    'email' => Arr::get(explode("/", $value['Email ID']), '0'),
                    'password' => $password,
                    // 'username' => $value['Email ID'],
                    // 'job_desgination_id' => $value['Designation'],
                ]);
                $user->roles()->sync([
                    '2' => [],
                ]);

                $dob_str =  $value['DOB'];
                try {
                    $dob = Carbon::createFromFormat('d.m.Y', strtotime($dob_str));
                    //code...
                } catch (\Throwable $th) {
                report($th);
                    $dob = null;
                }
                $userDetail = ([
                    'aadhaar' => $value['Aadhar No.'],
                    'blood_group' => $value['Blood Group'],
                    'dob' => $dob,
                    'present_address_line_1' => $value['ADDRESS'],
                    'salary_ac_no' => $value['BANK ACCOUNT No.'],
                    'salary_ac_ifsc' => $value['IFSC CODE'],
                    'uan' => $value['UAN'],
                    'esic' => $value['ESIC'],
                    'pan' => $value['PAN NO.'],
                ]);
                $user->employeeDetails()->create($userDetail);
                // $userDetail->user()->associate($user);
            }
        }
    }


    private $userArray01 = [
        [
            "Name" => "Amit Kumar Singh",
            "Employee Code" => "20189037",
            "Mobile No." => "8100359343",
            "Aadhar No." => "743529010885",
            "Blood Group" => "O+",
            "DOB" => "19.06.1993",
            "ADDRESS" => "C/O- Biva Singh,3/1,Nafar Koley Road,Kolkata-700015",
            "Email ID" => "amitkumarsingh272@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Haridas Debnath",
            "Employee Code" => "20189038",
            "Mobile No." => "9830933613",
            "Aadhar No." => "463026990918",
            "Blood Group" => "A+",
            "DOB" => "15.08.1988",
            "ADDRESS" => "C/O- Anath Bardhan Debnath,Aswini Pally,Maniknagar,Barasat,N 24 Parganas,West Bengal,Kolkata-700124",
            "Email ID" => "debnath.prince@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Akash Mandal",
            "Employee Code" => "20189039",
            "Mobile No." => "7001205662",
            "Aadhar No." => "784719205320",
            "Blood Group" => "A+",
            "DOB" => "04.09.1998",
            "ADDRESS" => "C/O-Tapan Mondal,Vill+Po-Nildih,PS-Raghunathpur,Dist-Purulia,Pin-723133",
            "Email ID" => "mandalakash5662@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Manas Deshmukh",
            "Employee Code" => "20189040",
            "Mobile No." => "8972923380",
            "Aadhar No." => "761303673478",
            "Blood Group" => "B+",
            "DOB" => "04.12.1993",
            "ADDRESS" => "C/O-Naran Deshmukh,Vill+PO-Baharamuri Hatirampur,Dist-Bankura,PS-Hirbandh,Pin-722121",
            "Email ID" => "manasdeshmukhetc9@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Subrata De",
            "Employee Code" => "20189041",
            "Mobile No." => "9635112311",
            "Aadhar No." => "427221133449",
            "Blood Group" => "O+",
            "DOB" => "11.06.1998",
            "ADDRESS" => "C/O-Satyajit De,Vill+PO-Kiaboni,PS-Garhbeta,Dist-Paschim Medinipur,West Bengal,Pin-721253",
            "Email ID" => "subrataday100@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Sujoy Nandi",
            "Employee Code" => "20189042",
            "Mobile No." => "7001876068",
            "Aadhar No." => "209985621224",
            "Blood Group" => "B+",
            "DOB" => "05.02.1987",
            "ADDRESS" => "C/O-Santosh Nandi,11/8,Ram Mohan Sarani,Sabuj Nagar,Durgapur,Paschim Bardhaman,West Bengal-713203",
            "Email ID" => "sujoynandi134@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Anirban Chakraborty",
            "Employee Code" => "20189043",
            "Mobile No." => "9007100344",
            "Aadhar No." => "759209788744",
            "Blood Group" => "A+",
            "DOB" => "12.11.1999",
            "ADDRESS" => "C/O- Nabanita Chakraborty,Dui Pukur Khudirampally,PS-Barasat,Po-Kazipara,Dist-North 24 Parganas,Pin-700125",
            "Email ID" => "anirbanchakraborty8744@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Somnath Rana",
            "Employee Code" => "20189031",
            "Mobile No." => "9775238178",
            "Aadhar No." => "331656053350",
            "Blood Group" => "B+",
            "DOB" => "15.06.1993",
            "ADDRESS" => "C/O-Madhab Rana,Vill-Nankarchak,PO-Nandapur,PS-Chandipur,Dist-Purba Medinipur,PIN-721625",
            "Email ID" => "somnathrana9775@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Anirban Chatterjee",
            "Employee Code" => "20189019",
            "Mobile No." => "7908782537",
            "Aadhar No." => "312308001893",
            "Blood Group" => "B+",
            "DOB" => "29.07.1983",
            "ADDRESS" => "C/O-Mohan Das Chatterjee, Syamsundar Para,Kalna,Burdwan,Pin-713409",
            "Email ID" => "anirban83c@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Sanatan Samanta",
            "Employee Code" => "20189035",
            "Mobile No." => "6290911097/9641301383",
            "Aadhar No." => "818296686706",
            "Blood Group" => "O-",
            "DOB" => "12.05.1995",
            "ADDRESS" => "C/O-Nemai Samanta, Vill: Gobindpur, P.O- Gobindpur Shibtala,P.S-Jagatballav Pur,Dist.-Howrah,Pin:711414",
            "Email ID" => "sanatan00092@gmail.com/ sanatan.samanta2018@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Bhabatosh Banerjee",
            "Employee Code" => "20189018",
            "Mobile No." => "9002374032",
            "Aadhar No." => "464351673756",
            "Blood Group" => "B+",
            "DOB" => "22.08.1991",
            "ADDRESS" => "C/O- Prasanta Banerjee,Vill/P.O-Dharmapur,P.S-Gaighata,North 24 PGS,Pin-743249",
            "Email ID" => "tech.bhabatosh@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Sarup Biswas",
            "Employee Code" => "20189008",
            "Mobile No." => "8927943704/8617259694",
            "Aadhar No." => "343080297011",
            "Blood Group" => "O+",
            "DOB" => "15.08.1993",
            "ADDRESS" => "C/O-Subal Biswas,Vill-Deara,P.O-Mangalgonj,P.S-Bagdah,Dist-North 24 PGS,Pin-743297",
            "Email ID" => "sarupbiswas078@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Pritam Mal",
            "Employee Code" => "20189012",
            "Mobile No." => "7890064775/8777694880",
            "Aadhar No." => "670335381052",
            "Blood Group" => "A+",
            "DOB" => "05.05.2000",
            "ADDRESS" => "C/O- Gautam Mal,Vill/P/O- Muchisha,P.S- Nodakhali,Dist-South 24 PGS,Pin-743377",
            "Email ID" => "pritam05052000@gmailcom",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Milan Sarkar",
            "Employee Code" => "20189014",
            "Mobile No." => "9231828179",
            "Aadhar No." => "350917973854",
            "Blood Group" => "O+",
            "DOB" => "04.03.1986",
            "ADDRESS" => "C/O-Kishori Mohan Sarkar,Pritilata Sarani.Dist-North 24 PGS,P.S-Barasat,Pin-700126",
            "Email ID" => "milansarkar4@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Chinmoy Das",
            "Employee Code" => "20189020",
            "Mobile No." => "9748084206",
            "Aadhar No." => "408146732529",
            "Blood Group" => "O+",
            "DOB" => "18.09.1986",
            "ADDRESS" => "C/O-Gour Mohan Das,Vill/P.O-Dakshin Chatra(Aarobindu Rd.),P.S-Badduria,Dist.-North 24 PGS,Pin-743247",
            "Email ID" => "chinmoydas.msl@gmail.com",
            "Designation" => "",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Trinanjan Nath",
            "Employee Code" => "20189026",
            "Mobile No." => "9593018804",
            "Aadhar No." => "488629448700",
            "Blood Group" => "B+",
            "DOB" => "11.11.1996",
            "ADDRESS" => "C/O-Bimal Kanti Nath,Vill-Kamarthuba.P.O- Hathuba,P.S-Habra,Dist-North 24 PGS",
            "Email ID" => "trinanjannath49@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Mrinmoy Halder",
            "Employee Code" => "20189036",
            "Mobile No." => "9748078528",
            "Aadhar No." => "415400189560",
            "Blood Group" => "??",
            "DOB" => "27.09.2000",
            "ADDRESS" => "C/O-Ananada Halder,Nabapally,Barasat,Kolkata-700126",
            "Email ID" => "heldermrinmoy20@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Tapas Sardar",
            "Employee Code" => "20189023",
            "Mobile No." => "8116008034",
            "Aadhar No." => "487602999738",
            "Blood Group" => "B+",
            "DOB" => "08.05.1993",
            "ADDRESS" => "C/O- Mongal Sardar,Vill-Shibnagar,P.O-Doltala Ghola,P.S-Canning,Pin-743376",
            "Email ID" => "sarder.tapas93@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "MD.Rahmatullah Molla",
            "Employee Code" => "20189045",
            "Mobile No." => "8972633779",
            "Aadhar No." => "262531747383",
            "Blood Group" => "",
            "DOB" => "30.01.1994",
            "ADDRESS" => "C/O-MD.Nuruddin Molla,Vill-Mirzapur,P.O-Hansury,P.S-Magrahat,Dist-South 24 PGS,Pin-743609",
            "Email ID" => "rahmatmolla11@gmailcom",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Sandipan Debnath",
            "Employee Code" => "20189002",
            "Mobile No." => "8972021316",
            "Aadhar No." => "306001192522",
            "Blood Group" => "A+",
            "DOB" => "20.10.1988",
            "ADDRESS" => "C/O-Sushanta Debnath,Vill/P.O- Shimulpur,P.S-Habra,Dist-North 24 PGS,Pin-743289",
            "Email ID" => "sandipandebnath1988@gmail.com",
            "Designation" => "Sr. Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Suman Rana",
            "Employee Code" => "20189034",
            "Mobile No." => "8906483081",
            "Aadhar No." => "755540286876",
            "Blood Group" => "B+",
            "DOB" => "28.06.1998",
            "ADDRESS" => "C/O-Uttam Rana,Vill-Betalbasan,P.O-Ganja Narayanpur,P.S-Nandakumar,Dis-Purba medinipur,Pin-721648",
            "Email ID" => "sumanrana1998yahoo@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Avik Roy",
            "Employee Code" => "20189013",
            "Mobile No." => "8910657238",
            "Aadhar No." => "473920058697",
            "Blood Group" => "B+",
            "DOB" => "10.12.1991",
            "ADDRESS" => "C/O-Saroj Roy,Vill-Debpur,P.O-Radhakantopur,P.S-Memaria,Dist-Purba Bardhaman",
            "Email ID" => "avik47roy@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Soumen Das",
            "Employee Code" => "20189028",
            "Mobile No." => "7550968585",
            "Aadhar No." => "476203307008",
            "Blood Group" => "O+",
            "DOB" => "01.03.1990",
            "ADDRESS" => "C/O-Sailendra Kumar Das,Vill/P.O-Sitahati,P.S-Ketugram,Dist-Purba Bardhaman,Pin-713123",
            "Email ID" => "soumen.jbm@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Arijit Giri",
            "Employee Code" => "20189015",
            "Mobile No." => "9051998120",
            "Aadhar No." => "577902371702",
            "Blood Group" => "B-",
            "DOB" => "22.12.1990",
            "ADDRESS" => "C/O-Kartik Giri,Vill/P.O-Ramganga,Dist-South 24 PGS,P.S-Patharpratima,Pin-743371",
            "Email ID" => "arijit.giri1990@gmail.com",
            "Designation" => "Customer engineer",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Sk.Sajahan",
            "Employee Code" => "20189016",
            "Mobile No." => "9002184215",
            "Aadhar No." => "602792609061",
            "Blood Group" => "B+",
            "DOB" => "20.12.1989",
            "ADDRESS" => "C/O-,Water tank Road(Hazipur),P.O-Diamond Harbour,Dist-South 24 PGS,Pin-743331",
            "Email ID" => "sk.sajahan286@gmail.com",
            "Designation" => "Team Leader",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Shahnaz Begum",
            "Employee Code" => "20189044",
            "Mobile No." => "9073559740",
            "Aadhar No." => "688762354009",
            "Blood Group" => "A+",
            "DOB" => "07.03.1993",
            "ADDRESS" => "C/O-Saiful Haque,\"The Nest Living\" 34 Bellilious Road,Howrah-711101",
            "Email ID" => "zoyahaque3@gmailcom",
            "Designation" => "CALL CO-ORDINATOR",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "UJJAL ROY",
            "Employee Code" => "20189001",
            "Mobile No." => "9831027360",
            "Aadhar No." => "9706 2778 8505",
            "Blood Group" => "",
            "DOB" => "28.11.1984",
            "ADDRESS" => "",
            "Email ID" => "ujjal.r@triinfotek.com",
            "Designation" => "MANAGER",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SUMAN TARAFDAR",
            "Employee Code" => "",
            "Mobile No." => "8927411950",
            "Aadhar No." => "2506 4550 9201",
            "Blood Group" => "",
            "DOB" => "04.04.19",
            "ADDRESS" => "",
            "Email ID" => "suman.t@triinfotek.com",
            "Designation" => "MANAGER",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SOMNATH RANA",
            "Employee Code" => "20189031",
            "Mobile No." => "6200362064",
            "Aadhar No." => "3316 5605 3350",
            "Blood Group" => "B +",
            "DOB" => "15.06.1993",
            "ADDRESS" => "C/O-Madhab Rana, Vill- Nankarchak,P.O-Nandapur,P.S-Chandipur,Dist- Purba Medinipur,Pin-721625",
            "Email ID" => "somnathrana9775@gmail.com",
            "Designation" => "TEAM LEADER (ZO)",
            "BANK ACCOUNT No." => "4201535368",
            "IFSC CODE" => "ICIC0000042",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "MILAN SARKAR",
            "Employee Code" => "20189014",
            "Mobile No." => "9231828179",
            "Aadhar No." => "3509 1797 3854",
            "Blood Group" => "O +",
            "DOB" => "04.03.1986",
            "ADDRESS" => "C/O-Kishori Mohan Sarkar, Pritilata Sarani,P.S-Barasat,Dist-North 24 PGS,Pin-700126",
            "Email ID" => "milansarkar4@gmail.com",
            "Designation" => "TEAM LEADER (NORTH)",
            "BANK ACCOUNT No." => "11216984884",
            "IFSC CODE" => "SBIN000024",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "AVIK ROY",
            "Employee Code" => "20189013",
            "Mobile No." => "8910657238",
            "Aadhar No." => "4739 2005 8697",
            "Blood Group" => "B +",
            "DOB" => "10.12.1991",
            "ADDRESS" => "C/O-Saroj Roy, Vill-Debpur,P.O-Radhakantopur,P.S-Memaria,Dist-Purba Bardhaman.",
            "Email ID" => "avik47roy@gmail.com",
            "Designation" => "TEAM LEADER (SOUTH)",
            "BANK ACCOUNT No." => "2380000100152888",
            "IFSC CODE" => "PUNB0238000",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SK.SAJAHAN",
            "Employee Code" => "20189016",
            "Mobile No." => "9002184215",
            "Aadhar No." => "6027 9260 9061",
            "Blood Group" => "B +",
            "DOB" => "20.12.1989",
            "ADDRESS" => "Water Tank Road(Hazipur),P.O-Diamond Harbour, Dist- Soth 24 PGS,Pin-743331",
            "Email ID" => "sk.sajahan286@gmailcom",
            "Designation" => "TEAM LEADER (SOUTH 24-PGS)",
            "BANK ACCOUNT No." => "128101502504",
            "IFSC CODE" => "ICIC0000524",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SOUMEN DAS",
            "Employee Code" => "20189028",
            "Mobile No." => "7550968585",
            "Aadhar No." => "4762 0330 7008",
            "Blood Group" => "O +",
            "DOB" => "01.03.1990",
            "ADDRESS" => "C/O-Sailendra kumar Das, Vill+P.O-Sitahati,P.S-Ketugram,Dist-Purba Bardhaman,Pin-71323",
            "Email ID" => "soumen.jbm@gmail.com",
            "Designation" => "TEAM LEADER (PURULIA)",
            "BANK ACCOUNT No." => "31440509049",
            "IFSC CODE" => "SBIN0003913",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "BHABATOSH BANERJEE",
            "Employee Code" => "20189018",
            "Mobile No." => "9002374032",
            "Aadhar No." => "4643 5167 3756",
            "Blood Group" => "B +",
            "DOB" => "22.08.1991",
            "ADDRESS" => "C/O-Prasanta Banerjee, Vill+P.O-Dharmapur,P.S-Gaighata,Dist-North 24 PGS,Pin-743249",
            "Email ID" => "tech.bhabatosh@gmail.com",
            "Designation" => "TEAM LEADER (EAST)",
            "BANK ACCOUNT No." => "50100250814483",
            "IFSC CODE" => "HDFC0003474",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SARUP BISWAS",
            "Employee Code" => "20189008",
            "Mobile No." => "8927943704/861729694",
            "Aadhar No." => "3430 8029 7011",
            "Blood Group" => "O +",
            "DOB" => "15.08.1993",
            "ADDRESS" => "C/O-Subal Biswas,Vill-Deara,P.O-Mangalgonj,P.S-Bagdah,Dist-North 24 PGS,Pin-743297",
            "Email ID" => "sarupbiswas078@gmail.com",
            "Designation" => "TEAM LEADER (WEST)",
            "BANK ACCOUNT No." => "92000101814640",
            "IFSC CODE" => "PUNB0009200",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "AKASH MANDAL",
            "Employee Code" => "20189039",
            "Mobile No." => "7001205662",
            "Aadhar No." => "7847 1920 5320",
            "Blood Group" => "A +",
            "DOB" => "04.09.1998",
            "ADDRESS" => "C/O-Tapan Mandal,Vill+P.O-Nildih,P.S-Raghunathpur,Dist-Purulia,Pin-723133",
            "Email ID" => "mandalakash@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "427210110008740",
            "IFSC CODE" => "BKID0004272",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SUMAN RANA",
            "Employee Code" => "20189034",
            "Mobile No." => "8906483081",
            "Aadhar No." => "7555 4028 6876",
            "Blood Group" => "B +",
            "DOB" => "28.06.1998",
            "ADDRESS" => "C/O- Uttam Rana,Vill-Betalbasan,P.O-Ganja Narayanpur,P.S-Nandakumar,Dist-Purba Medinipur,Pin-721648",
            "Email ID" => "sumanrana1998yahoo@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1048010198462",
            "IFSC CODE" => "PUNB0104820",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "PRITAM MAL",
            "Employee Code" => "20189012",
            "Mobile No." => "7890064775/8777694880",
            "Aadhar No." => "6703 3538 1052",
            "Blood Group" => "A +",
            "DOB" => "05.05.2000",
            "ADDRESS" => "C/O-Gautam Mal, Vill+P.O- Muchisha,P.S-Nodakhali,Dist-South 24 PGS,Pin-743377",
            "Email ID" => "pritam05052000@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "92000101814987",
            "IFSC CODE" => "PUNB0009200",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "ZOYA HAQUE",
            "Employee Code" => "20189044",
            "Mobile No." => "9073559740",
            "Aadhar No." => "6887 6235 4009",
            "Blood Group" => "A +",
            "DOB" => "07.03.1993",
            "ADDRESS" => "C/O-Saiful Haque,\"The Nest Living\" 34 Bellilious Road,Howrah-711101",
            "Email ID" => "zoyahaque3@gmail.com",
            "Designation" => "CALL CO-ORDINATOR",
            "BANK ACCOUNT No." => "6.096E+15",
            "IFSC CODE" => "PUNB0609600",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "TAPAS SARDAR",
            "Employee Code" => "20189023",
            "Mobile No." => "8116008034",
            "Aadhar No." => "4876 0299 9738",
            "Blood Group" => "B +",
            "DOB" => "08.05.1993",
            "ADDRESS" => "C/O-Mongal Sardar, Vill-Shibnagar,P.O-Doltala Ghola,P.S-Canning,Pin-743376",
            "Email ID" => "sardar.tapas93@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "139010354950",
            "IFSC CODE" => "PUNB0013920",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "MD.RAHMATULLAH MOLLA",
            "Employee Code" => "20189045",
            "Mobile No." => "8972633779",
            "Aadhar No." => "2625 3174 7383",
            "Blood Group" => "",
            "DOB" => "30.01.1994",
            "ADDRESS" => "C/O-Md.Nuruuddin Molla, Vill-Mirzapur,P.O-Hansury,P.S-Magrahat,Dist-South 24 PGS",
            "Email ID" => "rahamatmolla11@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1767001500017557",
            "IFSC CODE" => "PUNB0176700",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "ARIJIT GIRI",
            "Employee Code" => "20189015",
            "Mobile No." => "9051998120",
            "Aadhar No." => "5779 0237 1702",
            "Blood Group" => "B -",
            "DOB" => "22.12.1990",
            "ADDRESS" => "C/O-Kartik Giri,Vill+P.O-Ramganga,P.S-Patharpratima,Dist-South 24 PGS,Pin-743371",
            "Email ID" => "arijit.giri1990@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "104901505498",
            "IFSC CODE" => "ICIC0001049",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "AMIT KUMAR SINGH",
            "Employee Code" => "20189037",
            "Mobile No." => "8100359343",
            "Aadhar No." => "7435 2901 0885",
            "Blood Group" => "O +",
            "DOB" => "19.06.1993",
            "ADDRESS" => "C/O-Biva Singh, 3/1 Nafar Koley Road,Kolkata-700015.",
            "Email ID" => "amitkumarsingh272@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1963000101236556",
            "IFSC CODE" => "PUNB0196300",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SANATAN SAMANTA",
            "Employee Code" => "20189035",
            "Mobile No." => "6290911097/9641301383",
            "Aadhar No." => "8182 9668 6706",
            "Blood Group" => "O -",
            "DOB" => "12.05.1995",
            "ADDRESS" => "C/O-Nemai Samanta, Vill-Gobindapur,P.O-Gobindapur Shibtala,P.S-Jagatballavpur,Dist-Howrah,Pin-711414",
            "Email ID" => "sanatan00092@gmail.com/sanatansamanta2018@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1165010403146",
            "IFSC CODE" => "PUNB0116520",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "ANIRBAN CHATTERJEE",
            "Employee Code" => "20189019",
            "Mobile No." => "7908782537",
            "Aadhar No." => "3123 0800 1893",
            "Blood Group" => "B +",
            "DOB" => "29.07.1983",
            "ADDRESS" => "C/O-Mohan Das Chatterjee, Shyamsundar para,Kalna,Burdwan,Pin-713409",
            "Email ID" => "anirban83c@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1495000100104467",
            "IFSC CODE" => "PUNB0149500",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "ANIRBAN CHAKRABORTY",
            "Employee Code" => "20189043",
            "Mobile No." => "9007100344",
            "Aadhar No." => "7592 0978 8744",
            "Blood Group" => "A +",
            "DOB" => "12.11.1999",
            "ADDRESS" => "C/O-Nabanita Chakraborty, Dui Pukur Khudirampally,P.S- Barasat,P.O-Kazipara,Dist-North 24 PGS,Pin-700125",
            "Email ID" => "anirbanchakraborty8744@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "6550110063330",
            "IFSC CODE" => "UCBA0000655",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "MRINMOY HALDER",
            "Employee Code" => "20189036",
            "Mobile No." => "9748078528",
            "Aadhar No." => "4154 0018 9560",
            "Blood Group" => "",
            "DOB" => "27.09.2000",
            "ADDRESS" => "C/O-Ananda Halder, Nabapally, Barasat,Kolkata-700126",
            "Email ID" => "mrinmoyhalder299@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "140820010003078",
            "IFSC CODE" => "PUNB0140820",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "AKASH DUTTA",
            "Employee Code" => "20189046",
            "Mobile No." => "6295157177",
            "Aadhar No." => "4199 0904 7313",
            "Blood Group" => "B +",
            "DOB" => "09.07.2003",
            "ADDRESS" => "C/O-Ashis Dutta, Vill-Matiari,P.S-Kaliganj,Dist-Nadia,Pin-741153",
            "Email ID" => "akashdutta200309@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "622200100000142",
            "IFSC CODE" => "PUNB0062220",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "KANTU KUNDU",
            "Employee Code" => "20189047",
            "Mobile No." => "9635958955",
            "Aadhar No." => "4332 2631 5967",
            "Blood Group" => "O +",
            "DOB" => "29.12.1991",
            "ADDRESS" => "C/O-Badal Kundu.Vill-Sinduria,P.O-Shipur,P.S-Egra,Dist-Purba Medinipur,Pin-721448.",
            "Email ID" => "kantukundu2016@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "33273069080",
            "IFSC CODE" => "SBIN0009711",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SAMIR SABJI",
            "Employee Code" => "20189048",
            "Mobile No." => "8348976511",
            "Aadhar No." => "9156 1122 9447",
            "Blood Group" => "",
            "DOB" => "02.12.2001",
            "ADDRESS" => "C/O-Safruddin Sabji,Vill-Goyeshpur Koltapara,P.O-Jhaljhaliya,P.S-English Bazar,Dist-Malda,Pin-732102",
            "Email ID" => "samirkhan8759@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "36068640550",
            "IFSC CODE" => "SBIN0010428",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "RAJIB MAITY",
            "Employee Code" => "20189049",
            "Mobile No." => "9547944039",
            "Aadhar No." => "8156 8580 3175",
            "Blood Group" => "",
            "DOB" => "13.04.1994",
            "ADDRESS" => "C/O-Aloke Maity,Vill+ P.O - Sagarpur , P.S. - Daspur, Dist - Pashchim Medinipur,Pin - 721211",
            "Email ID" => "",
            "Designation" => "TEAM LEADER (BURDWAN)",
            "BANK ACCOUNT No." => "37585461712",
            "IFSC CODE" => "SBIN0012442",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SHAMIM SHAIKH",
            "Employee Code" => "20189051",
            "Mobile No." => "7866803207/967994398",
            "Aadhar No." => "6701 8952 2215",
            "Blood Group" => "",
            "DOB" => "11.05.1999",
            "ADDRESS" => "C/O-Khokan Ali Shaikh,Vill+P.O-Amghata,P.S-Kotwali,Dist-Nadia,Pin-741315",
            "Email ID" => "shamimshaikh3489@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "59105769118",
            "IFSC CODE" => "IDIB000T541",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SOURAV MONDAL",
            "Employee Code" => "20189052",
            "Mobile No." => "9064525963/9883910862",
            "Aadhar No." => "8124 4513 0704",
            "Blood Group" => "",
            "DOB" => "20.05.1998",
            "ADDRESS" => "C/O-Ananda Mondal,Vill-Laxminathpur,P.O-Gayeshpur Hazratala,P.S-Santipur,Dist-Nadia,Pin-741404",
            "Email ID" => "sourov50342@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "33548383177",
            "IFSC CODE" => "SBIN0000176",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SUBHANKAR GHOSH",
            "Employee Code" => "20189053",
            "Mobile No." => "7501883922",
            "Aadhar No." => "626779881864",
            "Blood Group" => "",
            "DOB" => "29.07.1994",
            "ADDRESS" => "C/O-Pradip Ghosh,Itapukur,Chakda,Nadia",
            "Email ID" => "ghoshsubhankar958@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "422110510000739",
            "IFSC CODE" => "BKID0004221",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "THAKURDAS MAHATO",
            "Employee Code" => "20189050",
            "Mobile No." => "7001020784/8670717172",
            "Aadhar No." => "3188 5071 6541",
            "Blood Group" => "",
            "DOB" => "21.12.1997",
            "ADDRESS" => "C/O-Sunil Mahato,Vill- Baliguma, P.O- Bijoydih, P.S- Kenda, DIST-Purulia, Pin code- 723128, West Bengal",
            "Email ID" => "thakurdas7172@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "34374429453",
            "IFSC CODE" => "SBIN0002085",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "DEBJIT PAL",
            "Employee Code" => "20189054",
            "Mobile No." => "8918810718/9382335568",
            "Aadhar No." => "3721 3736 3577",
            "Blood Group" => "B +",
            "DOB" => "01.05.2002",
            "ADDRESS" => "C/O- Kamana Pal, 46, Saheb Danga Para, Shantipur,Nadia- 740104",
            "Email ID" => "debjitpal814@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "CHAITANYA MODAK",
            "Employee Code" => "20189055",
            "Mobile No." => "7407187870/7602531644",
            "Aadhar No." => "4265 7571 2788",
            "Blood Group" => "O +",
            "DOB" => "19.03.1995",
            "ADDRESS" => "C/O- Shyamapada Modak, Vill/P.O: Fusrabad,P.S: Para Dist- Purulia.West Bengal-723126",
            "Email ID" => "chaitanyamodak92@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "21760110029640",
            "IFSC CODE" => "UCBA0002176",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "CHIRANJIT MANDAL",
            "Employee Code" => "20189056",
            "Mobile No." => "8670516877",
            "Aadhar No." => "4627 7238 1462",
            "Blood Group" => "O +",
            "DOB" => "20.04.1990",
            "ADDRESS" => "C/O- Rajen Mandal, Vill: Bara Mohanpara, P.O: Amrity, P.S: English Bazar, Dist.: Malda,West Bengal: 732208",
            "Email ID" => "cmandal159@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "3.975E+15",
            "IFSC CODE" => "PUNB0397500",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "BISWAJIT PAUL",
            "Employee Code" => "20189059",
            "Mobile No." => "9002617370",
            "Aadhar No." => "3683 6179 5945",
            "Blood Group" => "A +",
            "DOB" => "05.06.1990",
            "ADDRESS" => "C/O-Naaran Paul,,Balurghat ,Dakshin Dinajpur ,West Bengal,PIN-733103",
            "Email ID" => "biswajitpaulmalancha@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "611002010005391",
            "IFSC CODE" => "UBIN0561100",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SANJOY DUTTA",
            "Employee Code" => "20189057",
            "Mobile No." => "9854815112",
            "Aadhar No." => "8460 8130 0454",
            "Blood Group" => "A +",
            "DOB" => "07.08.1970",
            "ADDRESS" => "C/O-MUKHURI DUTTA,ATILA GAON, JORHAT, ASSAM-785001",
            "Email ID" => "sanjoy47@yahoo.com",
            "Designation" => "TEAM LEADER (JORHAT)",
            "BANK ACCOUNT No." => "30254061084",
            "IFSC CODE" => "SBIN0009192",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "JIMI RAJKHOWA",
            "Employee Code" => "20189058",
            "Mobile No." => "9401706252",
            "Aadhar No." => "8471 4062 8246",
            "Blood Group" => "B +",
            "DOB" => "09.12.1977",
            "ADDRESS" => "C/O-LALIT CHANDRA RAJKHOWA,NEAR DONBOSCO SCHOOL LICHUBARI,PO - CINAMARA, PS - JORHAT,JORHAT, ASSAM-785008",
            "Email ID" => "jimi.rajkhowa@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "30378552324",
            "IFSC CODE" => "SBIN0009192",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SHUBHAM SIKDAR",
            "Employee Code" => "20189061",
            "Mobile No." => "7602185678",
            "Aadhar No." => "2117 68483 242",
            "Blood Group" => "B +",
            "DOB" => "08.12.2001",
            "ADDRESS" => "C/O- SWAPAN SIKDAR,VILL-NUTANDIH , P.O. - UPAR SANKRA , P.S. - RAGHUNATHPUR , DIST - PURULIA , PIN CODE - 723133",
            "Email ID" => "sikdarshubham2001@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "5231559323",
            "IFSC CODE" => "CBIN0283427",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SATYAJIT DAS",
            "Employee Code" => "20189064",
            "Mobile No." => "9101009232",
            "Aadhar No." => "9137 7458 1262",
            "Blood Group" => "B +",
            "DOB" => "01.02.1992",
            "ADDRESS" => "C/O-CHARU DAS, RAHA TOWN, WARD NO.-5, P.O+P.S- RAHA, DIST.- NAGAON ASSAM, PIN-782103",
            "Email ID" => "dsatyajit583@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "30823277952",
            "IFSC CODE" => "SBIN0002103",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SUMON BORAH",
            "Employee Code" => "20189062",
            "Mobile No." => "7399770708",
            "Aadhar No." => "3867 9039 5445",
            "Blood Group" => "B +",
            "DOB" => "04.07.1994",
            "ADDRESS" => "C/O-RITA BORAH , JAIL ROAD MEDICAL INSTITUTE  MISSION GATE , KAKOTI GAON JORHAT",
            "Email ID" => "sumonborah7@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "20116507487",
            "IFSC CODE" => "SBIN0001275",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Bhargab Nath",
            "Employee Code" => "20189063",
            "Mobile No." => "8638296571/8638584570",
            "Aadhar No." => "3147 3262 4290",
            "Blood Group" => "AB +",
            "DOB" => "26.06.1994",
            "ADDRESS" => "C/O- MANMOHAN NATH,JYOTINAGAR, WARD NO.-8, P.O+PS-MORIGAON, DIST.-MORIGAON ASSAM, PIN-782105",
            "Email ID" => "bhaaargab@gmail.com",
            "Designation" => "TEAM LEADER(NAGAON)",
            "BANK ACCOUNT No." => "4601583257",
            "IFSC CODE" => "ICIC0002588",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "R.K Harry",
            "Employee Code" => "20189065",
            "Mobile No." => "8787782208/8415923072",
            "Aadhar No." => "",
            "Blood Group" => "O +",
            "DOB" => "22.02.1994",
            "ADDRESS" => "C/O-R.K SUKHA SINGH, KHURAI CHAIRENTHONG,P.O & P.S- IMPHAL, IMPHAL EAST, MANIPUR-795010",
            "Email ID" => "rk.harry09@gmail.com",
            "Designation" => "TEAM LEADER(IMPHAL)",
            "BANK ACCOUNT No." => "791010240932",
            "IFSC CODE" => "",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Naorem John Singh",
            "Employee Code" => "20189066",
            "Mobile No." => "7005136446",
            "Aadhar No." => "3931 3352 6712",
            "Blood Group" => "O +",
            "DOB" => "04.03.1993",
            "ADDRESS" => "C/O-NAOREM SANAHAL DEVI,KYMGEI PAN AHANBI NEAR BAZAR SHED OPP. NISSAN ILAND CANCHIPUR, IMPHAL WEST 795003",
            "Email ID" => "naoremjohnsingh@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "32253141593",
            "IFSC CODE" => "SBIN0010757",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Indranil Dey",
            "Employee Code" => "20189067",
            "Mobile No." => "9073052412",
            "Aadhar No." => "2676 0322 2876",
            "Blood Group" => "O -",
            "DOB" => "02.10.2002",
            "ADDRESS" => "C/O- BIKASH DEY,VILL- PUMLIA P.O+ P.S- CHAKDAHA, DIST.-NADIA, PIN-741222",
            "Email ID" => "idey6208@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "389200400000572",
            "IFSC CODE" => "PUNB0038920",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Anirban Halder",
            "Employee Code" => "20189068",
            "Mobile No." => "8240864094",
            "Aadhar No." => "8188 7727 1759",
            "Blood Group" => "A -",
            "DOB" => "06.01.2000",
            "ADDRESS" => "C/O- RAMENDRA NATH HALDER, MADHYA BALURIA, P.O- NABAPALLY, P.S- BARASAT, DIST.-NORTH 24 PGS,PIN-700126",
            "Email ID" => "halder.anirban.2008@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "2689101010900",
            "IFSC CODE" => "CNRB0002689",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Partha Das",
            "Employee Code" => "20189069",
            "Mobile No." => "9641160459",
            "Aadhar No." => "9585 9270 3933",
            "Blood Group" => "AB +",
            "DOB" => "24.09.1990",
            "ADDRESS" => "C/O- GOVINDA DAS, VILL.+P.O.- BELARI, DIST-BURDWAN. PIN-713141.",
            "Email ID" => "roni111omg@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "4832191002978",
            "IFSC CODE" => "PUNB0048310",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Jakib Hussain",
            "Employee Code" => "20189070",
            "Mobile No." => "9101448037",
            "Aadhar No." => "4118 9869 0637",
            "Blood Group" => "B +",
            "DOB" => "21.11.1990",
            "ADDRESS" => "C/O-ANGUR HUSSAIN, MOHBUNDHA CHAH BAGICHA, MOHBUNDHA GRANT, P.O- SATRIA, P.S- PULIBOR,DIST.- JORHAT ASSAM-785616",
            "Email ID" => "jakibhussain9@gmail.com",
            "Designation" => "OJT",
            "BANK ACCOUNT No." => "34133406826",
            "IFSC CODE" => "SBIN0009192",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "Pankaj Borchetia",
            "Employee Code" => "20189071",
            "Mobile No." => "8638476742",
            "Aadhar No." => "891549352618",
            "Blood Group" => "B +",
            "DOB" => "03.12.1990",
            "ADDRESS" => "C/O- RAJEN BORCHETIA, Vill-KAKODONGA CHABUKDHARA GAON ,P.O-NAMKHATWAL ,P.S-DERGAON ,Dist-GOLAGHAT, PIN - 785626, ASSAM",
            "Email ID" => "pankajborchetia@gmail.com",
            "Designation" => "CUSTOMER ENGINEER",
            "BANK ACCOUNT No." => "1478000100137936",
            "IFSC CODE" => "PUNB0081320",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SOUMEN DAS",
            "Employee Code" => "20189028",
            "Mobile No." => "7550968585",
            "Aadhar No." => "4762 0330 7008",
            "Blood Group" => "",
            "DOB" => "01.03.1990",
            "ADDRESS" => "C/O-Sailendra kumar Das, Vill+P.O-Sitahati,P.S-Ketugram,Dist-Purba Bardhaman,Pin-71323",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "31440509049",
            "IFSC CODE" => "SBIN0003913",
            "MICR" => "713002112",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => "BHIPD7113B"
        ],
        [
            "Name" => "AKASH MANDAL",
            "Employee Code" => "20189039",
            "Mobile No." => "7001205662",
            "Aadhar No." => "7847 1920 5320",
            "Blood Group" => "",
            "DOB" => "04.09.1998",
            "ADDRESS" => "C/O-Tapan Mandal,Vill+P.O-Nildih,P.S-Raghunathpur,Dist-Purulia,Pin-723133",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "427210110008740",
            "IFSC CODE" => "BKID0004272",
            "MICR" => "",
            "UAN" => "101749387473",
            "ESIC" => "4118175863",
            "PAN NO." => ""
        ],
        [
            "Name" => "SUMAN RANA",
            "Employee Code" => "20189034",
            "Mobile No." => "8906483081",
            "Aadhar No." => "7555 4028 6876",
            "Blood Group" => "",
            "DOB" => "28.06.1998",
            "ADDRESS" => "C/O- Uttam Rana,Vill-Betalbasan,P.O-Ganja Narayanpur,P.S-Nandakumar,Dist-Purba Medinipur,Pin-721648",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "1048010198462",
            "IFSC CODE" => "PUNB0104820",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "TAPAS SARDAR",
            "Employee Code" => "20189023",
            "Mobile No." => "8116008034",
            "Aadhar No." => "4876 0299 9738",
            "Blood Group" => "",
            "DOB" => "08.05.1993",
            "ADDRESS" => "C/O-Mongal Sardar, Vill-Shibnagar,P.O-Doltala Ghola,P.S-Canning,Pin-743376",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "139010354950",
            "IFSC CODE" => "PUNB0013920",
            "MICR" => "700024318",
            "UAN" => "101296276671",
            "ESIC" => "",
            "PAN NO." => "HAUPS2410F"
        ],
        [
            "Name" => "MD.RAHMATULLAH MOLLA",
            "Employee Code" => "20189045",
            "Mobile No." => "8972633779",
            "Aadhar No." => "2625 3174 7383",
            "Blood Group" => "",
            "DOB" => "30.01.1994",
            "ADDRESS" => "C/O-Md.Nuruuddin Molla, Vill-Mirzapur,P.O-Hansury,P.S-Magrahat,Dist-South 24 PGS",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "1767001500017557",
            "IFSC CODE" => "PUNB0176700",
            "MICR" => "700024502",
            "UAN" => "101522960119",
            "ESIC" => "4117302010",
            "PAN NO." => "DWYPM8837E"
        ],
        [
            "Name" => "ARIJIT GIRI",
            "Employee Code" => "20189015",
            "Mobile No." => "9051998120",
            "Aadhar No." => "5779 0237 1702",
            "Blood Group" => "",
            "DOB" => "22.12.1990",
            "ADDRESS" => "C/O-Kartik Giri,Vill+P.O-Ramganga,P.S-Patharpratima,Dist-South 24 PGS,Pin-743371",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "104901505498",
            "IFSC CODE" => "ICIC0001049",
            "MICR" => "",
            "UAN" => "100982791380",
            "ESIC" => "",
            "PAN NO." => "BERPG0138P"
        ],
        [
            "Name" => "AMIT KUMAR SINGH",
            "Employee Code" => "20189037",
            "Mobile No." => "8100359343",
            "Aadhar No." => "7435 2901 0885",
            "Blood Group" => "",
            "DOB" => "19.06.1993",
            "ADDRESS" => "C/O-Biva Singh, 3/1 Nafar Koley Road,Kolkata-700015.",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "1963000101236556",
            "IFSC CODE" => "PUNB0196300",
            "MICR" => "R22940480",
            "UAN" => "101447508683",
            "ESIC" => "4116987653",
            "PAN NO." => "DRHPS7993M"
        ],
        [
            "Name" => "SANATAN SAMANTA",
            "Employee Code" => "20189035",
            "Mobile No." => "6290911097",
            "Aadhar No." => "8182 9668 6706",
            "Blood Group" => "",
            "DOB" => "12.05.1995",
            "ADDRESS" => "C/O-Nemai Samanta, Vill-Gobindapur,P.O-Gobindapur Shibtala,P.S-Jagatballavpur,Dist-Howrah,Pin-711414",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "1165010403146",
            "IFSC CODE" => "PUNB0116520",
            "MICR" => "",
            "UAN" => "101591558984",
            "ESIC" => "",
            "PAN NO." => "KTOPS5756L"
        ],
        [
            "Name" => "ANIRBAN CHAKRABORTY",
            "Employee Code" => "20189043",
            "Mobile No." => "9007100344",
            "Aadhar No." => "7592 0978 8744",
            "Blood Group" => "",
            "DOB" => "12.11.1999",
            "ADDRESS" => "C/O-Nabanita Chakraborty, Dui Pukur Khudirampally,P.S- Barasat,P.O-Kazipara,Dist-North 24 PGS,Pin-700125",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "6550110063330",
            "IFSC CODE" => "UCBA0000655",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "MRINMOY HALDER",
            "Employee Code" => "20189036",
            "Mobile No." => "9748078528",
            "Aadhar No." => "4154 0018 9560",
            "Blood Group" => "",
            "DOB" => "27.09.2000",
            "ADDRESS" => "C/O-Ananda Halder, Nabapally, Barasat,Kolkata-700126",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "140820010003078",
            "IFSC CODE" => "PUNB0140820",
            "MICR" => "70024355",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => "BACPH0185G"
        ],
        [
            "Name" => "AKASH DUTTA",
            "Employee Code" => "20189046",
            "Mobile No." => "6295157177",
            "Aadhar No." => "4199 0904 7313",
            "Blood Group" => "",
            "DOB" => "09.07.2003",
            "ADDRESS" => "C/O-Ashis Dutta, Vill-Matiari,P.S-Kaliganj,Dist-Nadia,Pin-741153",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "622200100000142",
            "IFSC CODE" => "PUNB0062220",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "KANTU KUNDU",
            "Employee Code" => "20189047",
            "Mobile No." => "9635958955",
            "Aadhar No." => "4332 2631 5967",
            "Blood Group" => "",
            "DOB" => "29.12.1991",
            "ADDRESS" => "C/O-Badal Kundu.Vill-Sinduria,P.O-Shipur,P.S-Egra,Dist-Purba Medinipur,Pin-721448.",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "33273069080",
            "IFSC CODE" => "SBIN0009711",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => ""
        ],
        [
            "Name" => "SAMIR SABJI",
            "Employee Code" => "20189048",
            "Mobile No." => "8348976511",
            "Aadhar No." => "9156 1122 9447",
            "Blood Group" => "",
            "DOB" => "02.12.2001",
            "ADDRESS" => "C/O-Safruddin Sabji,Vill-Goyeshpur Koltapara,P.O-Jhaljhaliya,P.S-English Bazar,Dist-Malda,Pin-732102",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "36068640550",
            "IFSC CODE" => "SBIN0010428",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => "PBKPS4461P"
        ],
        [
            "Name" => "RAJIB MAITY",
            "Employee Code" => "20189049",
            "Mobile No." => "9547944039",
            "Aadhar No." => "8156 8580 3175",
            "Blood Group" => "",
            "DOB" => "13.04.1994",
            "ADDRESS" => "C/O-Aloke Maity,Vill+ P.O - Sagarpur , P.S. - Daspur, Dist - Pashchim Medinipur,Pin - 721211",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "37585461712",
            "IFSC CODE" => "SBIN0012442",
            "MICR" => "721002709",
            "UAN" => "101393155499",
            "ESIC" => "4116800226",
            "PAN NO." => "CJLPM9012N"
        ],
        [
            "Name" => "ZOYA HAQUE",
            "Employee Code" => "20189044",
            "Mobile No." => "9073559740",
            "Aadhar No." => "6887 6235 4009",
            "Blood Group" => "",
            "DOB" => "07.03.1993",
            "ADDRESS" => "C/O-Saiful Haque, \"The Nest Living\" 34 Belilious Road,Howrah-711101",
            "Email ID" => "",
            "Designation" => "",
            "BANK ACCOUNT No." => "6.096E+15",
            "IFSC CODE" => "PUNB069600",
            "MICR" => "",
            "UAN" => "",
            "ESIC" => "",
            "PAN NO." => "FBRPB8429R"
        ]
    ];
}
