<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\SpecialPlannedDay;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SpecialPlannedDayController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = SpecialPlannedDay::class;
    }

    public function index()
    {
        abort_if(Gate::denies('special_planned_day_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.special-planned-day.index');
    }

    public function create()
    {
        abort_if(Gate::denies('special_planned_day_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.special-planned-day.create');
    }

    public function edit(SpecialPlannedDay $specialPlannedDay)
    {
        abort_if(Gate::denies('special_planned_day_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.special-planned-day.edit', compact('specialPlannedDay'));
    }

    public function show(SpecialPlannedDay $specialPlannedDay)
    {
        abort_if(Gate::denies('special_planned_day_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.special-planned-day.show', compact('specialPlannedDay'));
    }
}
