<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Circle;
use App\Models\Client;
use App\Models\ClientGroup;
use App\Models\State;
use App\Models\Zone;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Seeder001Controller extends Controller
{


    private static $StateZoneArray = [
        [
            "State" => "Rajasthan",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Madhya Pradesh",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Gujarat",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Daman & Diu",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Dadra & Nagar Haveli",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Maharashtra",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Goa",
            "Zone" => "West Zone"
        ],
        [
            "State" => "Andhra Pradesh",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Karnataka",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Lakshadweep",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Kerala",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Tamil Nadu",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Puducherry",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Andaman & Nicobar",
            "Zone" => "South Zone"
        ],
        [
            "State" => "Jammu & Kashmir",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Himachal Pradesh",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Punjab",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Chandigarh",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Uttarakhand",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Haryana",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Delhi",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Uttar Pradesh",
            "Zone" => "North Zone"
        ],
        [
            "State" => "Bihar",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Sikkim",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Arunachal Pradesh",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Nagaland",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Manipur",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Mizoram",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Tripura",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Meghalaya",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Assam",
            "Zone" => "East Zone"
        ],
        [
            "State" => "West Bengal",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Jharkhand",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Odisha",
            "Zone" => "East Zone"
        ],
        [
            "State" => "Chhattisgarh",
            "Zone" => "East Zone"
        ]
    ];

    public static function SeedStatesAndZones()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        State::truncate()->get();
        Zone::truncate()->get();
        // $Zones = collect(self::$StateZoneArray)->map(fn ($v) => $v['Zone'])->unique();
        // dd($Zones);
        $ZonesChunked = collect(self::$StateZoneArray)->groupBy(fn ($v) => $v['Zone'])->toArray();
        // dd($ZonesChunked);

        foreach ($ZonesChunked as $ZoneName => $States) {
            $zoneOb = Zone::create([
                'name' => $ZoneName,
                'is_active' => 1,
            ]);
            foreach ($States as  $stateWAr) {
                $zoneOb->states()->create([
                    'name' => $stateWAr['State'],
                    'is_active' => 1,
                ]);
            }
        }


        $wbState = State::where('name', 'West Bengal')->first();
        if ($wbState) {
            //    $kolCircle =  Circle::create([
            $kolCircle = $wbState->circles()->create([
                'name' => 'Kolkata',
                'is_active' => 1,
            ]);

            if ($kolCircle) {
                $kolCircle->regions()->create([
                    'name' => 'KOLKATA - WEST',
                    'is_active' => 1,
                ]);
                $kolCircle->regions()->create([
                    'name' => 'KOLKATA - EAST',
                    'is_active' => 1,
                ]);
                $kolCircle->regions()->create([
                    'name' => 'KOLKATA - NORTH',
                    'is_active' => 1,
                ]);
                $kolCircle->regions()->create([
                    'name' => 'KOLKATA - SOUTH',
                    'is_active' => 1,
                ]);
            }
        }

        $pnbClientGroup =  ClientGroup::create([
            'name' => 'PNB',
            'business_name' => 'PUNJAB NATIONAL BANK'
        ]);
        $pnbWestBengal = Client::create([
            'client_group_id' => $pnbClientGroup->id,
            'state_id' => $wbState->id,
            'name' => "PNB West Bengal",
        ]);



        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        return Zone::with('states')->get();
    }

    public static function seedWithRawData()
    {
    }
}
