<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\Region;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class RegionController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = Region::class;
    }

    public function index()
    {
        abort_if(Gate::denies('region_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.region.index');
    }

    public function create()
    {
        abort_if(Gate::denies('region_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.region.create');
    }

    public function edit(Region $region)
    {
        abort_if(Gate::denies('region_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.region.edit', compact('region'));
    }

    public function show(Region $region)
    {
        abort_if(Gate::denies('region_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $region->load('circle');

        return view('admin.region.show', compact('region'));
    }
}
