<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProductZonePivot;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ProductZonePivotController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('product_zone_pivot_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-zone-pivot.index');
    }

    public function create()
    {
        abort_if(Gate::denies('product_zone_pivot_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-zone-pivot.create');
    }

    public function edit(ProductZonePivot $productZonePivot)
    {
        abort_if(Gate::denies('product_zone_pivot_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.product-zone-pivot.edit', compact('productZonePivot'));
    }

    public function show(ProductZonePivot $productZonePivot)
    {
        abort_if(Gate::denies('product_zone_pivot_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $productZonePivot->load('product', 'zone', 'lastUpdatedBy');

        return view('admin.product-zone-pivot.show', compact('productZonePivot'));
    }
}
