<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LgAttributeValue;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LgAttributeValueController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('lg_attribute_value_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute-value.index');
    }

    public function create()
    {
        abort_if(Gate::denies('lg_attribute_value_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute-value.create');
    }

    public function edit(LgAttributeValue $lgAttributeValue)
    {
        abort_if(Gate::denies('lg_attribute_value_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute-value.edit', compact('lgAttributeValue'));
    }

    public function show(LgAttributeValue $lgAttributeValue)
    {
        abort_if(Gate::denies('lg_attribute_value_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $lgAttributeValue->load('ledgerGroupAttribute');

        return view('admin.lg-attribute-value.show', compact('lgAttributeValue'));
    }
}
